/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.content.Context;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import org.solovyev.android.checkout.BaseInventory;
import org.solovyev.android.checkout.Checkout;
import org.solovyev.android.checkout.Inventory;
import org.solovyev.android.checkout.ProductTypes;
import org.solovyev.android.checkout.RobotmediaDatabase;

public final class RobotmediaInventory
extends BaseInventory {
    @Nonnull
    private final Executor mBackground;
    @Nonnull
    private final Executor mOnLoadExecutor;

    public RobotmediaInventory(@Nonnull Checkout checkout, @Nonnull Executor onLoadExecutor) {
        this(checkout, Executors.newSingleThreadExecutor(), onLoadExecutor);
    }

    public RobotmediaInventory(@Nonnull Checkout checkout, @Nonnull Executor background, @Nonnull Executor onLoadExecutor) {
        super(checkout);
        this.mBackground = background;
        this.mOnLoadExecutor = onLoadExecutor;
    }

    @Override
    @Nonnull
    protected Runnable createWorker(@Nonnull BaseInventory.Task task) {
        return new Worker(task);
    }

    private class Worker
    implements Runnable {
        @Nonnull
        private final BaseInventory.Task mTask;

        Worker(BaseInventory.Task task) {
            this.mTask = task;
        }

        @Override
        public void run() {
            if (RobotmediaDatabase.exists(RobotmediaInventory.this.mCheckout.getContext())) {
                RobotmediaInventory.this.mBackground.execute(new Loader());
            } else {
                this.onLoaded(RobotmediaDatabase.toInventoryProducts(ProductTypes.ALL));
            }
        }

        private void onLoaded(final @Nonnull Inventory.Products products) {
            RobotmediaInventory.this.mOnLoadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Worker.this.mTask.onDone(products);
                }
            });
        }

        private class Loader
        implements Runnable {
            private Loader() {
            }

            @Override
            public void run() {
                Context context = RobotmediaInventory.this.mCheckout.getContext();
                RobotmediaDatabase database = new RobotmediaDatabase(context);
                Inventory.Products products = database.load(Worker.this.mTask.getRequest());
                Worker.this.onLoaded(products);
            }
        }
    }
}

