/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.material;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.material.MaterialColor;
import org.solovyev.android.material.R;

final class ButtonBase {
    @Nonnull
    private final MaterialColor color = new MaterialColor(R.color.material_button_selector);
    @Nonnull
    private final View view;
    private boolean prepared;

    public ButtonBase(@Nonnull View view) {
        this.view = view;
    }

    private static boolean isLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    void init(@Nonnull Context context, @Nullable AttributeSet attrs) {
        this.color.init(context, attrs);
        this.updateColor();
    }

    private void updateColor() {
        Drawable newDrawable;
        Drawable oldDrawable = this.view.getBackground();
        if (oldDrawable != (newDrawable = this.prepareDrawable(oldDrawable))) {
            this.prepared = true;
            if (Build.VERSION.SDK_INT >= 16) {
                this.view.setBackground(newDrawable);
            } else {
                this.view.setBackgroundDrawable(newDrawable);
            }
            this.prepared = false;
        }
    }

    @Nullable
    Drawable prepareDrawable(@Nullable Drawable drawable2) {
        if (drawable2 != null && !this.prepared) {
            if (ButtonBase.isLollipop()) {
                if (!this.color.isDefaultColorList()) {
                    drawable2.setColorFilter(this.color.getColorList().getDefaultColor(), PorterDuff.Mode.SRC_IN);
                }
            } else {
                Resources r = this.view.getResources();
                int ih = r.getDimensionPixelSize(R.dimen.button_inset_horizontal);
                int iv = r.getDimensionPixelSize(R.dimen.button_inset_vertical);
                StateListDrawable stateDrawable = new StateListDrawable();
                this.addState(stateDrawable, 16842910, 16842919);
                this.addState(stateDrawable, -16842910);
                this.addState(stateDrawable, 16842910);
                return new InsetDrawable((Drawable)stateDrawable, ih, iv, ih, iv);
            }
        }
        return drawable2;
    }

    private void addState(@Nonnull StateListDrawable drawable2, int ... states) {
        Resources r = this.view.getResources();
        int defaultColor = r.getColor(R.color.material_button);
        int color2 = this.color.getColorList().getColorForState(states, defaultColor);
        drawable2.addState(states, this.makeButtonShape(color2));
    }

    @Nonnull
    private Drawable makeButtonShape(int color2) {
        Resources r = this.view.getResources();
        Drawable drawable2 = r.getDrawable(R.drawable.material_button_shape);
        if (drawable2 instanceof GradientDrawable) {
            drawable2.mutate();
            ((GradientDrawable)drawable2).setColor(color2);
        } else {
            Log.e((String)"Material", (String)"Unable to set accent color for drawable.");
        }
        return drawable2;
    }

    public void setColor(@Nonnull ColorStateList color2) {
        if (this.color.setColorList(color2)) {
            this.updateColor();
        }
    }
}

