/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.material;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.material.R;

public final class MaterialColor {
    private final int defaultColorListResId;
    private ColorStateList colorList;
    private boolean defaultColorList;

    public MaterialColor(int defaultColorListResId) {
        this.defaultColorListResId = defaultColorListResId;
    }

    public void init(@Nonnull Context context, @Nullable AttributeSet attrs) {
        Resources resources = context.getResources();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Material);
            if (a.hasValue(R.styleable.Material_materialColor)) {
                this.colorList = a.getColorStateList(R.styleable.Material_materialColor);
            } else {
                this.defaultColorList = true;
                this.colorList = resources.getColorStateList(this.defaultColorListResId);
            }
            a.recycle();
        } else {
            this.defaultColorList = true;
            this.colorList = resources.getColorStateList(this.defaultColorListResId);
        }
    }

    @Nonnull
    public ColorStateList getColorList() {
        return this.colorList;
    }

    public boolean setColorList(@Nonnull ColorStateList colorList) {
        if (!this.colorList.equals(colorList)) {
            this.colorList = colorList;
            this.defaultColorList = false;
            return true;
        }
        return false;
    }

    public boolean isDefaultColorList() {
        return this.defaultColorList;
    }
}

