/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.material.preferences;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import javax.annotation.Nonnull;
import org.solovyev.android.material.MaterialColor;
import org.solovyev.android.material.R;

public class Preference
extends android.preference.Preference {
    @Nonnull
    private final MaterialColor color = new MaterialColor(R.color.material_text_selector);

    @TargetApi(value=21)
    public Preference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.color.init(context, attrs);
    }

    public Preference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.color.init(context, attrs);
    }

    public Preference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.color.init(context, attrs);
    }

    public Preference(Context context) {
        super(context);
        this.color.init(context, null);
    }

    static void fixSummaryTextColor(@Nonnull MaterialColor color2, View view) {
        View summary;
        if (Build.VERSION.SDK_INT < 11 && TextUtils.equals((CharSequence)Build.MANUFACTURER, (CharSequence)"samsung") && (summary = view.findViewById(0x1020010)) instanceof TextView) {
            ((TextView)summary).setTextColor(color2.getColorList());
        }
    }

    protected View onCreateView(ViewGroup parent) {
        View view = super.onCreateView(parent);
        Preference.fixSummaryTextColor(this.color, view);
        return view;
    }
}

