/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.material.preferences;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.support.v4.app.ListFragment;
import android.widget.ListView;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public class PreferenceManagerCompat {
    private static final int FIRST_REQUEST_CODE = 100;
    private static final int MSG_BIND_PREFERENCES = 0;
    private final Handler uiHandler = new PreferenceHandler(this);
    @Nonnull
    private final PreferenceManager preferenceManager;
    @Nonnull
    private final ListFragment fragment;

    public PreferenceManagerCompat(@Nonnull ListFragment fragment) {
        this.fragment = fragment;
        this.preferenceManager = PreferenceManagerCompat.newPreferenceManager((Activity)fragment.getActivity());
    }

    @Nonnull
    private static PreferenceManager newPreferenceManager(@Nonnull Activity activity) {
        try {
            Constructor c = PreferenceManager.class.getDeclaredConstructor(Activity.class, Integer.TYPE);
            c.setAccessible(true);
            return (PreferenceManager)c.newInstance(activity, 100);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public PreferenceManager getPreferenceManager() {
        return this.preferenceManager;
    }

    public void addPreferencesFromResource(int preferencesResId, @Nonnull Context themeContext) {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("inflateFromResource", Context.class, Integer.TYPE, PreferenceScreen.class);
            m.setAccessible(true);
            PreferenceScreen preferenceScreen = (PreferenceScreen)m.invoke((Object)this.preferenceManager, themeContext, preferencesResId, this.getPreferenceScreen());
            if (preferenceScreen != null) {
                this.setPreferenceScreen(preferenceScreen);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addPreferencesFromResource(int preferencesResId) {
        this.addPreferencesFromResource(preferencesResId, (Context)this.fragment.getActivity());
    }

    public PreferenceScreen getPreferenceScreen() {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("getPreferenceScreen", new Class[0]);
            m.setAccessible(true);
            return (PreferenceScreen)m.invoke((Object)this.preferenceManager, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setPreferenceScreen(@Nonnull PreferenceScreen preferenceScreen) {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("setPreferences", PreferenceScreen.class);
            m.setAccessible(true);
            boolean result = (Boolean)m.invoke((Object)this.preferenceManager, preferenceScreen);
            if (result) {
                this.postBindPreferences();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void postBindPreferences() {
        if (!this.uiHandler.hasMessages(0)) {
            this.uiHandler.obtainMessage(0).sendToTarget();
        }
    }

    private void bindPreferences() {
        ListView lv;
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null && (lv = this.fragment.getListView()) != null) {
            preferenceScreen.bind(lv);
        }
    }

    public Preference findPreference(CharSequence key) {
        return this.preferenceManager.findPreference(key);
    }

    public void onDestroy() {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("dispatchActivityDestroy", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this.preferenceManager, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("dispatchActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
            m.setAccessible(true);
            m.invoke((Object)this.preferenceManager, requestCode, resultCode, data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onStop() {
        try {
            Method m = PreferenceManager.class.getDeclaredMethod("dispatchActivityStop", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this.preferenceManager, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onDestroyView() {
        this.uiHandler.removeMessages(0);
    }

    private static class PreferenceHandler
    extends Handler {
        @Nonnull
        private final WeakReference<PreferenceManagerCompat> r;

        private PreferenceHandler(@Nonnull PreferenceManagerCompat manager) {
            this.r = new WeakReference<PreferenceManagerCompat>(manager);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    PreferenceManagerCompat manager = (PreferenceManagerCompat)this.r.get();
                    if (manager == null) break;
                    manager.bindPreferences();
                }
            }
        }
    }
}

