/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.material.preferences;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceScreen;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.ListFragment;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.material.preferences.PreferenceManagerCompat;

public class PreferencesFragment
extends ListFragment {
    public static final String FRAGMENT_TAG = "preferences";
    protected static final int NO_THEME = -1;
    private static final String ARG_PREFERENCES_RES_ID = "preferences_res_id";
    private static final String ARG_LAYOUT_RES_ID = "layout_res_id";
    private static final String ARG_THEME_RES_ID = "theme_res_id";
    @Nonnull
    protected PreferenceManagerCompat preferenceManager;
    private View root;
    private int preferencesResId;
    private int layoutResId;
    private int themeResId = -1;
    private Context themeContext;

    @Nonnull
    public static PreferencesFragment create(int preferencesResId, int layoutResId) {
        return PreferencesFragment.create(preferencesResId, layoutResId, -1);
    }

    @Nonnull
    public static PreferencesFragment create(int preferencesResId, int layoutResId, int themeResId) {
        PreferencesFragment fragment = new PreferencesFragment();
        fragment.setArguments(PreferencesFragment.createArguments(preferencesResId, layoutResId, themeResId));
        return fragment;
    }

    @Nonnull
    protected static Bundle createArguments(int preferencesResId, int layoutResId, int themeResId) {
        Bundle args = new Bundle();
        args.putInt(ARG_PREFERENCES_RES_ID, preferencesResId);
        args.putInt(ARG_LAYOUT_RES_ID, layoutResId);
        args.putInt(ARG_THEME_RES_ID, themeResId);
        return args;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.preferenceManager = new PreferenceManagerCompat(this);
        Bundle arguments = this.getArguments();
        this.preferencesResId = arguments.getInt(ARG_PREFERENCES_RES_ID);
        this.layoutResId = arguments.getInt(ARG_LAYOUT_RES_ID);
        this.themeResId = arguments.getInt(ARG_THEME_RES_ID);
    }

    protected void prepareListView(@Nonnull ListView lv) {
        lv.setScrollBarStyle(0);
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        LayoutInflater themeInflater;
        if (this.themeResId == -1) {
            this.themeContext = this.getActivity();
            themeInflater = inflater;
        } else {
            this.themeContext = new ContextThemeWrapper((Context)this.getActivity(), this.themeResId);
            themeInflater = LayoutInflater.from((Context)this.themeContext);
        }
        this.root = themeInflater.inflate(this.layoutResId, null);
        ListView lv = (ListView)this.root.findViewById(16908298);
        this.prepareListView(lv);
        this.onCreateView(this.themeContext, themeInflater, this.root, container, savedInstanceState);
        return this.root;
    }

    protected void onCreateView(@Nonnull Context context, @Nonnull LayoutInflater inflater, @Nonnull View root, @Nullable ViewGroup container, @Nullable Bundle b) {
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        PreferenceScreen preferenceScreen;
        super.onViewCreated(view, savedInstanceState);
        this.preferenceManager.addPreferencesFromResource(this.preferencesResId, this.themeContext);
        FragmentActivity activity = this.getActivity();
        if (activity instanceof OnPreferenceAttachedListener && (preferenceScreen = this.preferenceManager.getPreferenceScreen()) != null) {
            ((OnPreferenceAttachedListener)activity).onPreferenceAttached(preferenceScreen, this.preferencesResId);
        }
    }

    @Nullable
    public PreferenceScreen getPreferenceScreen() {
        return this.preferenceManager.getPreferenceScreen();
    }

    public void onDestroyView() {
        this.preferenceManager.onDestroyView();
        super.onDestroyView();
        ViewParent rootParent = this.root.getParent();
        if (rootParent != null) {
            ((ViewGroup)rootParent).removeView(this.root);
        }
    }

    public void onStop() {
        this.preferenceManager.onStop();
        super.onStop();
    }

    public void onDestroy() {
        this.root = null;
        this.preferenceManager.onDestroy();
        super.onDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.preferenceManager.onActivityResult(requestCode, resultCode, data);
    }

    public void addPreferencesFromIntent(Intent intent) {
        throw new RuntimeException("too lazy to include this bs");
    }

    public Preference findPreference(CharSequence key) {
        return this.preferenceManager.findPreference(key);
    }

    public int getPreferencesResId() {
        return this.preferencesResId;
    }

    public static interface OnPreferenceAttachedListener {
        public void onPreferenceAttached(PreferenceScreen var1, int var2);
    }
}

