/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.elasticsearch;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.RestClient;
import org.ssssssss.magicapi.elasticsearch.ElasticSearchConnection;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.script.annotation.Comment;

public class ElasticSearchIndex {
    private final RestClient restClient;
    private final String name;
    private final String type;

    public ElasticSearchIndex(RestClient restClient, String name, String type) {
        this.restClient = restClient;
        this.name = name;
        this.type = type;
    }

    @Comment(value="\u6839\u636e`_id`\u4fdd\u5b58\uff0c\u5f53\u5b58\u5728\u65f6\u66f4\u65b0\uff0c\u4e0d\u5b58\u5728\u65f6\u63d2\u5165")
    public Object save(@Comment(value="_id", name="_id") String _id, @Comment(value="\u4fdd\u5b58\u5bf9\u8c61", name="data") Object data) throws IOException {
        return this.connect("/%s/%s/%s", this.name, this.type, _id).post(data);
    }

    @Comment(value="\u4e0d\u6307\u5b9a`_id`\u63d2\u5165")
    public Object insert(@Comment(value="\u63d2\u5165\u5bf9\u8c61", name="data") Object data) throws IOException {
        return this.connect("/%s/%s", this.name, this.type).post(data);
    }

    @Comment(value="\u6307\u5b9a`_id`\u63d2\u5165\uff0c\u5f53`_id`\u5b58\u5728\u65f6\u4e0d\u4f1a\u66f4\u65b0")
    public Object insert(@Comment(value="_id", name="_id") String _id, @Comment(value="\u63d2\u5165\u5bf9\u8c61", name="data") Object data) throws IOException {
        return this.connect("/%s/%s/%s/_create", this.name, this.type, _id).post(data);
    }

    @Comment(value="\u6839\u636e`id`\u5220\u9664")
    public Object delete(@Comment(value="id", name="id") String id) throws IOException {
        return this.connect("/%s/%s/%s", this.name, this.type, id).delete();
    }

    @Comment(value="\u6279\u91cf\u4fdd\u5b58\uff0c\u5f53\u5305\u542b`id`\u65f6\uff0c\u5219\u4f7f\u7528\u8be5\u5217\u503c\u5339\u914d\u4fdd\u5b58")
    public Object bulkSave(@Comment(value="\u4fdd\u5b58\u5185\u5bb9", name="list") List<Map<String, Object>> list) throws IOException {
        StringBuilder builder = new StringBuilder();
        list.forEach(item -> {
            Object id = item.get("id");
            if (id != null) {
                builder.append(String.format("{ \"index\":{ \"_id\": \"%s\" } }\r\n", id));
            } else {
                builder.append("{ \"index\":{} }\r\n");
            }
            builder.append(JsonUtils.toJsonStringWithoutPretty((Object)item));
            builder.append("\r\n");
        });
        return this.connect("/%s/%s/_bulk", this.name, this.type).post(builder.toString());
    }

    @Comment(value="\u6839\u636e`_id`\u4fee\u6539")
    public Object update(@Comment(value="_id", name="_id") String _id, @Comment(value="\u4fee\u6539\u9879", name="data") Object data) throws IOException {
        return this.connect("/%s/%s/%s", this.name, this.type, _id).post(Collections.singletonMap("doc", data));
    }

    @Comment(value="\u641c\u7d22")
    public Object search(@Comment(value="\u641c\u7d22`DSL`\u8bed\u53e5", name="dsl") Map<String, Object> dsl) throws IOException {
        return this.connect("/%s/_search", this.name).post(dsl);
    }

    private ElasticSearchConnection connect(String format, Object ... args) {
        return new ElasticSearchConnection(this.restClient, String.format(format, args));
    }
}

