/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.ssssssss.magicapi.core.config.MessageType;
import org.ssssssss.magicapi.core.context.MagicConsoleSession;
import org.ssssssss.magicapi.core.event.EventAction;
import org.ssssssss.magicapi.core.model.MagicNotify;
import org.ssssssss.magicapi.core.model.Pair;
import org.ssssssss.magicapi.core.service.MagicNotifyService;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.script.MagicScriptDebugContext;

public class WebSocketSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionManager.class);
    private static final Map<String, MagicConsoleSession> SESSIONS = new ConcurrentHashMap<String, MagicConsoleSession>();
    private static MagicNotifyService magicNotifyService;
    private static final Map<String, MagicScriptDebugContext> CONTEXTS;
    private static String instanceId;
    private static final int CHECK_INTERVAL = 20;
    private static final int KEEPALIVE_TIMEOUT = 60000;
    private static final List<Pair<String, String>> MESSAGE_CACHE;

    public static void add(MagicConsoleSession session) {
        SESSIONS.put(session.getClientId(), session);
    }

    public static MagicConsoleSession getConsoleSession(String clientId) {
        return SESSIONS.get(clientId);
    }

    public static Collection<MagicConsoleSession> getSessions() {
        return SESSIONS.values();
    }

    public static void remove(MagicConsoleSession session) {
        if (session.getClientId() != null) {
            WebSocketSessionManager.remove(session.getClientId());
        }
    }

    public static void remove(String sessionId) {
        SESSIONS.remove(sessionId);
    }

    public static void sendToAll(MessageType messageType, Object ... values) {
        String content = WebSocketSessionManager.buildMessage(messageType, values);
        WebSocketSessionManager.sendToAll(content);
    }

    private static void sendToAll(String content) {
        WebSocketSessionManager.getSessions().stream().filter(MagicConsoleSession::writeable).forEach(session -> WebSocketSessionManager.sendBySession(session, content));
        WebSocketSessionManager.sendToMachineByClientId(null, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendLogs(String sessionId, String message) {
        List<Pair<String, String>> list = MESSAGE_CACHE;
        synchronized (list) {
            MESSAGE_CACHE.add(Pair.of(sessionId, message));
            if (MESSAGE_CACHE.size() >= 100) {
                WebSocketSessionManager.flushLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushLog() {
        try {
            Map messages;
            List<Pair<String, String>> list = MESSAGE_CACHE;
            synchronized (list) {
                messages = MESSAGE_CACHE.stream().collect(Collectors.groupingBy(Pair::getFirst, Collectors.mapping(Pair::getSecond, Collectors.toList())));
                MESSAGE_CACHE.clear();
            }
            messages.forEach((clientId, logs) -> WebSocketSessionManager.sendByClientId(clientId, logs.size() > 1 ? MessageType.LOGS : MessageType.LOG, logs));
        }
        catch (Exception e) {
            logger.warn("\u53d1\u9001\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    public static void sendByClientId(String clientId, MessageType messageType, Object ... values) {
        MagicConsoleSession session = WebSocketSessionManager.findSession(clientId);
        String content = WebSocketSessionManager.buildMessage(messageType, values);
        if (session != null && session.writeable()) {
            WebSocketSessionManager.sendBySession(session, content);
        } else {
            WebSocketSessionManager.sendToMachineByClientId(clientId, content);
        }
    }

    public static void sendToOther(String excludeClientId, MessageType messageType, Object ... values) {
        String content = WebSocketSessionManager.buildMessage(messageType, values);
        WebSocketSessionManager.getSessions().stream().filter(MagicConsoleSession::writeable).filter(it -> !it.getClientId().equals(excludeClientId)).forEach(session -> WebSocketSessionManager.sendBySession(session, content));
        WebSocketSessionManager.sendToMachineByClientId(null, content);
    }

    public static void sendToMachineByClientId(String clientId, String content) {
        if (magicNotifyService != null) {
            magicNotifyService.sendNotify(new MagicNotify(instanceId, EventAction.WS_S_C, clientId, content));
        }
    }

    public static void sendToMachine(MessageType messageType, Object ... args) {
        if (magicNotifyService != null) {
            magicNotifyService.sendNotify(new MagicNotify(instanceId, EventAction.WS_S_S, null, WebSocketSessionManager.buildMessage(messageType, args)));
        }
    }

    public static String buildMessage(MessageType messageType, Object ... values) {
        StringBuilder builder = new StringBuilder(messageType.name().toLowerCase());
        if (values != null) {
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                builder.append(",");
                Object value = values[i];
                if (i + 1 < len || value instanceof CharSequence || value instanceof Number) {
                    builder.append(value);
                    continue;
                }
                builder.append(JsonUtils.toJsonString(value));
            }
        }
        return builder.toString();
    }

    public static void sendByClientId(String clientId, String content) {
        if (clientId == null) {
            WebSocketSessionManager.getSessions().stream().filter(MagicConsoleSession::writeable).forEach(session -> WebSocketSessionManager.sendBySession(session, content));
        } else {
            MagicConsoleSession session2 = WebSocketSessionManager.findSession(clientId);
            if (session2 != null) {
                WebSocketSessionManager.sendBySession(session2, content);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBySession(MagicConsoleSession session, String content) {
        block5: {
            try {
                if (session == null) break block5;
                String string = session.getClientId();
                synchronized (string) {
                    session.getWebSocketSession().sendMessage((WebSocketMessage)new TextMessage((CharSequence)content));
                }
            }
            catch (Exception e) {
                logger.warn("\u53d1\u9001WebSocket\u6d88\u606f\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
    }

    public static MagicConsoleSession findSession(String clientId) {
        return WebSocketSessionManager.getSessions().stream().filter(it -> Objects.equals(clientId, it.getClientId())).findFirst().orElse(null);
    }

    public static void setMagicNotifyService(MagicNotifyService magicNotifyService) {
        WebSocketSessionManager.magicNotifyService = magicNotifyService;
    }

    public static void setInstanceId(String instanceId) {
        WebSocketSessionManager.instanceId = instanceId;
    }

    public static void addMagicScriptContext(String sessionAndScriptId, MagicScriptDebugContext context) {
        CONTEXTS.put(sessionAndScriptId, context);
    }

    public static MagicScriptDebugContext findMagicScriptContext(String sessionAndScriptId) {
        return CONTEXTS.get(sessionAndScriptId);
    }

    public static void removeMagicScriptContext(String sessionAndScriptId) {
        CONTEXTS.remove(sessionAndScriptId);
    }

    private static void checkSession() {
        try {
            long activateTime = System.currentTimeMillis() - 60000L;
            SESSIONS.entrySet().stream().peek(it -> WebSocketSessionManager.sendBySession((MagicConsoleSession)it.getValue(), WebSocketSessionManager.buildMessage(MessageType.PING, new Object[0]))).filter(it -> ((MagicConsoleSession)it.getValue()).getActivateTime() < activateTime).collect(Collectors.toList()).forEach(entry -> {
                MagicConsoleSession session = (MagicConsoleSession)entry.getValue();
                SESSIONS.remove(entry.getKey());
                session.close();
                WebSocketSessionManager.sendToAll(MessageType.USER_LOGOUT, session.getAttributes());
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        CONTEXTS = new ConcurrentHashMap<String, MagicScriptDebugContext>();
        MESSAGE_CACHE = new ArrayList<Pair<String, String>>(200);
        new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "magic-api-send-log-task")).scheduleAtFixedRate(WebSocketSessionManager::flushLog, 1L, 1L, TimeUnit.SECONDS);
        new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "magic-api-websocket-clean-task")).scheduleAtFixedRate(WebSocketSessionManager::checkSession, 20L, 20L, TimeUnit.SECONDS);
    }
}

