/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service;

import java.nio.charset.StandardCharsets;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.utils.JsonUtils;

public interface MagicResourceStorage<T extends MagicEntity> {
    public static final String separatorWithCRLF = "\r\n================================\r\n";
    public static final String separatorWithLF = "\n================================\n";

    public String folder();

    public String suffix();

    public Class<T> magicClass();

    public boolean requirePath();

    default public boolean requiredScript() {
        return true;
    }

    default public boolean allowRoot() {
        return false;
    }

    default public T read(byte[] bytes) {
        String content = new String(bytes, StandardCharsets.UTF_8);
        if (this.requiredScript()) {
            String separator = separatorWithCRLF;
            int index = content.indexOf(separator);
            if (index == -1) {
                separator = separatorWithLF;
                index = content.indexOf(separatorWithLF);
            }
            if (index > -1) {
                MagicEntity info = (MagicEntity)JsonUtils.readValue(content.substring(0, index), this.magicClass());
                info.setScript(content.substring(index + separator.length()));
                return (T)info;
            }
        }
        return (T)((MagicEntity)JsonUtils.readValue(content, this.magicClass()));
    }

    default public byte[] write(MagicEntity entity) {
        entity = entity.copy();
        String script = entity.getScript();
        entity.setScript(null);
        return (JsonUtils.toJsonString(entity) + separatorWithCRLF + script).getBytes(StandardCharsets.UTF_8);
    }

    default public T readResource(Resource resource) {
        return this.read(resource.read());
    }

    public String buildMappingKey(T var1);

    default public String buildKey(MagicEntity entity) {
        return this.buildMappingKey(entity);
    }

    default public void validate(T entity) {
    }

    public void setMagicResourceService(MagicResourceService var1);
}

