/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.ssssssss.magicapi.core.config.JsonCodeConstants;
import org.ssssssss.magicapi.core.event.EventAction;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.event.MagicEvent;
import org.ssssssss.magicapi.core.exception.InvalidArgumentException;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.model.MagicNotify;
import org.ssssssss.magicapi.core.model.PathMagicEntity;
import org.ssssssss.magicapi.core.model.SelectedResource;
import org.ssssssss.magicapi.core.model.TreeNode;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.core.resource.ZipResource;
import org.ssssssss.magicapi.core.service.AbstractPathMagicResourceStorage;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.WebUtils;

public class DefaultMagicResourceService
implements MagicResourceService,
JsonCodeConstants,
ApplicationListener<ApplicationStartedEvent> {
    private final Resource root;
    private final Map<String, Resource> groupMappings = new HashMap<String, Resource>(16);
    private final Map<String, Group> groupCache = new HashMap<String, Group>(16);
    private final Map<String, Resource> fileMappings = new HashMap<String, Resource>(32);
    private final Map<String, MagicEntity> fileCache = new HashMap<String, MagicEntity>(32);
    private final Map<String, Map<String, String>> pathCache = new HashMap<String, Map<String, String>>(16);
    private final Map<String, MagicResourceStorage<? extends MagicEntity>> storages;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ApplicationEventPublisher publisher;
    private final Logger logger = LoggerFactory.getLogger(DefaultMagicResourceService.class);

    public DefaultMagicResourceService(Resource resource, List<MagicResourceStorage<? extends MagicEntity>> storages, ApplicationEventPublisher publisher) {
        this.root = resource;
        this.storages = storages.stream().peek(it -> it.setMagicResourceService(this)).collect(Collectors.toMap(MagicResourceStorage::folder, it -> it));
        this.publisher = publisher;
    }

    @Override
    public boolean processNotify(MagicNotify notify) {
        if ("file".equals(notify.getType())) {
            return this.processFileNotify(notify.getId(), notify.getAction());
        }
        if (notify.getAction() == EventAction.CLEAR) {
            this.read(false);
            return true;
        }
        return this.processGroupNotify(notify.getId(), notify.getAction());
    }

    private boolean processGroupNotify(String id, EventAction action) {
        TreeNode<Group> treeNode;
        Group group = this.groupCache.get(id);
        if (group == null) {
            this.readAll();
            group = this.groupCache.get(id);
        }
        if ((treeNode = this.tree(group.getType()).findTreeNode(it -> it.getId().equals(id))) != null) {
            GroupEvent event = new GroupEvent(group.getType(), action, group);
            event.setSource("notify");
            if (event.getAction() == EventAction.DELETE) {
                event.setEntities(this.deleteGroup(id));
            } else if (action != EventAction.CREATE) {
                Resource folder = this.groupMappings.get(id);
                folder.readAll();
                if (folder.exists()) {
                    this.refreshGroup(folder, this.storages.get(group.getType()));
                } else {
                    this.readAll();
                    treeNode = this.tree(group.getType()).findTreeNode(it -> it.getId().equals(id));
                }
                event.setGroup(this.groupCache.get(id));
                event.setEntities(treeNode.flat().stream().flatMap(g -> this.listFiles(g.getId()).stream()).collect(Collectors.toList()));
            }
            this.publisher.publishEvent((Object)event);
            return true;
        }
        return false;
    }

    private boolean processFileNotify(String id, EventAction action) {
        Group group;
        MagicEntity entity = this.fileCache.get(id);
        if (entity == null) {
            this.readAll();
            entity = this.fileCache.get(id);
        }
        if (entity != null && (group = this.groupCache.get(entity.getGroupId())) != null) {
            Map<String, String> pathCacheMap;
            MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(group.getType());
            Map<String, String> map = pathCacheMap = storage.requirePath() ? this.pathCache.get(storage.folder()) : null;
            if (action == EventAction.DELETE) {
                this.fileMappings.remove(id);
                entity = this.fileCache.remove(id);
                if (pathCacheMap != null) {
                    pathCacheMap.remove(id);
                }
            } else {
                Resource resource = this.fileMappings.get(id);
                resource.readAll();
                if (resource.exists()) {
                    entity = storage.read(resource.read());
                    this.putFile(storage, entity, resource);
                } else {
                    this.readAll();
                    entity = this.fileCache.get(id);
                }
            }
            this.publisher.publishEvent((Object)new FileEvent(group.getType(), action, entity, "notify"));
        }
        return false;
    }

    private void init() {
        this.groupMappings.clear();
        this.groupCache.clear();
        this.fileMappings.clear();
        this.fileCache.clear();
        this.pathCache.clear();
        this.storages.forEach((key, registry) -> {
            if (registry.requirePath()) {
                this.pathCache.put(registry.folder(), new HashMap(32));
            }
            Resource folder = this.root.getDirectory((String)key);
            if (registry.allowRoot()) {
                String rootId = key + ":0";
                Group group = new Group();
                group.setId(rootId);
                group.setType((String)key);
                group.setParentId("0");
                this.putGroup(group, folder);
            }
            if (!folder.exists()) {
                folder.mkdir();
            }
        });
    }

    private void read(boolean triggerEvent) {
        this.writeLock(() -> {
            if (triggerEvent) {
                this.publisher.publishEvent((Object)new MagicEvent("clear", EventAction.CLEAR));
            }
            this.readAll();
            this.fileCache.values().forEach(entity -> {
                Group group = this.groupCache.get(entity.getGroupId());
                this.publisher.publishEvent((Object)new FileEvent(group.getType(), EventAction.LOAD, (MagicEntity)entity));
            });
            return null;
        });
    }

    private void readAll() {
        this.writeLock(() -> {
            this.init();
            this.root.readAll();
            this.storages.forEach((key, registry) -> this.refreshGroup(this.root.getDirectory((String)key), (MagicResourceStorage<? extends MagicEntity>)registry));
            return null;
        });
    }

    @Override
    public void refresh() {
        this.read(true);
    }

    @Override
    public Resource getResource() {
        return this.root;
    }

    private void refreshGroup(Resource folder, MagicResourceStorage<? extends MagicEntity> storage) {
        if (storage.allowRoot()) {
            folder.files(storage.suffix()).forEach(file -> this.putFile(storage, (MagicEntity)storage.readResource((Resource)file), (Resource)file));
        } else {
            folder.dirs().forEach(dir -> {
                Resource meta = dir.getResource("group.json");
                if (meta.exists()) {
                    this.putGroup(JsonUtils.readValue(meta.read(), Group.class), (Resource)dir);
                    dir.files(storage.suffix()).forEach(file -> this.putFile(storage, (MagicEntity)storage.readResource((Resource)file), (Resource)file));
                }
            });
        }
    }

    @Override
    public boolean saveGroup(Group group) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        this.isTrue(this.storages.containsKey(group.getType()), NOT_SUPPORTED_GROUP_TYPE);
        this.notNull(group.getName(), NAME_REQUIRED);
        this.notNull(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notNull(group.getParentId(), GROUP_ID_REQUIRED);
        MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(group.getType());
        return this.writeLock(() -> {
            Resource groupResource;
            Resource resource;
            if ("0".equals(group.getParentId())) {
                resource = this.root.getDirectory(group.getType());
            } else {
                resource = this.getGroupResource(group.getParentId());
                this.isTrue(resource != null && resource.exists(), GROUP_NOT_FOUND);
            }
            GroupEvent event = new GroupEvent(group.getType(), group.getId() == null ? EventAction.CREATE : EventAction.SAVE, group);
            if (group.getId() == null || !this.groupCache.containsKey(group.getId())) {
                if (group.getId() == null) {
                    group.setId(UUID.randomUUID().toString().replace("-", ""));
                }
                group.setCreateTime(System.currentTimeMillis());
                group.setCreateBy(WebUtils.currentUserName());
                groupResource = resource.getDirectory(group.getName());
                this.isTrue(!groupResource.exists(), FILE_SAVE_FAILURE);
                groupResource.mkdir();
            } else {
                Group oldGroup = this.groupCache.get(group.getId());
                if (storage.requirePath() && !Objects.equals(oldGroup.getPath(), group.getPath())) {
                    TreeNode<Group> treeNode = this.tree(group.getType());
                    String oldPath = oldGroup.getPath();
                    oldGroup.setPath(group.getPath());
                    List entities = treeNode.findTreeNode(it -> it.getId().equals(group.getId())).flat().stream().flatMap(it -> this.fileCache.values().stream().filter(f -> f.getGroupId().equals(it.getId()))).collect(Collectors.toList());
                    for (MagicEntity entity : entities) {
                        String newMappingKey = storage.buildKey(entity);
                        if (!this.pathCache.get(group.getType()).entrySet().stream().anyMatch(entry -> ((String)entry.getValue()).equals(newMappingKey) && !((String)entry.getKey()).equals(entity.getId()))) continue;
                        oldGroup.setPath(oldPath);
                        throw new InvalidArgumentException(SAVE_GROUP_PATH_CONFLICT);
                    }
                }
                Resource oldResource = this.getGroupResource(group.getId());
                groupResource = resource.getDirectory(group.getName());
                this.isTrue(oldResource != null && oldResource.exists(), GROUP_NOT_FOUND);
                group.setUpdateBy(WebUtils.currentUserName());
                group.setUpdateTime(System.currentTimeMillis());
                if (!Objects.equals(oldGroup.getName(), group.getName())) {
                    this.isTrue(!groupResource.exists(), FILE_SAVE_FAILURE);
                    this.isTrue(oldResource.renameTo(groupResource), FILE_SAVE_FAILURE);
                }
            }
            if (groupResource.getResource("group.json").write(JsonUtils.toJsonString(group))) {
                this.putGroup(group, groupResource);
                TreeNode<Group> treeNode = this.tree(group.getType()).findTreeNode(it -> it.getId().equals(group.getId()));
                this.refreshGroup(groupResource, storage);
                if (event.getAction() != EventAction.CREATE) {
                    event.setEntities(treeNode.flat().stream().flatMap(g -> this.listFiles(g.getId()).stream()).collect(Collectors.toList()));
                }
                this.publisher.publishEvent((Object)event);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean move(String src, String groupId) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        Group group = this.groupCache.get(groupId);
        this.isTrue("0".equals(groupId) || group != null, GROUP_NOT_FOUND);
        this.isTrue(!Objects.equals(src, groupId), MOVE_NAME_CONFLICT);
        return this.writeLock(() -> {
            Group srcGroup = this.groupCache.get(src);
            if (srcGroup != null) {
                return this.moveGroup(srcGroup, groupId);
            }
            this.notNull(group, GROUP_NOT_FOUND);
            MagicEntity entity = this.fileCache.get(src);
            this.notNull(entity, FILE_NOT_FOUND);
            return this.moveFile(entity.copy(), group);
        });
    }

    @Override
    public String copyGroup(String src, String groupId) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        Group group = this.groupCache.get(groupId);
        this.isTrue("0".equals(groupId) || group != null, GROUP_NOT_FOUND);
        this.isTrue(!Objects.equals(src, groupId), SRC_GROUP_CONFLICT);
        Group srcGroup = this.groupCache.get(src);
        this.notNull(srcGroup, GROUP_NOT_FOUND);
        Group newGroup = new Group();
        newGroup.setType(srcGroup.getType());
        newGroup.setParentId(groupId);
        newGroup.setName(srcGroup.getName() + "(Copy)");
        newGroup.setPath(Objects.toString(srcGroup.getPath(), "") + "_copy");
        newGroup.setOptions(srcGroup.getOptions());
        newGroup.setPaths(srcGroup.getPaths());
        newGroup.setProperties(srcGroup.getProperties());
        this.saveGroup(newGroup);
        this.listFiles(src).stream().map(MagicEntity::copy).peek(it -> it.setGroupId(newGroup.getId())).peek(it -> it.setId(null)).forEach(this::saveFile);
        return newGroup.getId();
    }

    private boolean moveGroup(Group src, String target) {
        Resource resource;
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(src.getType());
        Resource targetResource = "0".equals(target) ? this.root.getDirectory(storage.folder()) : this.groupMappings.get(target);
        this.isTrue(!targetResource.getDirectory(src.getName()).exists(), MOVE_NAME_CONFLICT);
        targetResource = targetResource.getDirectory(src.getName());
        TreeNode<Group> treeNode = this.tree(storage.folder());
        String oldParentId = src.getParentId();
        src.setParentId(target);
        List<MagicEntity> entities = treeNode.findTreeNode(it -> it.getId().equals(src.getId())).flat().stream().flatMap(it -> this.fileCache.values().stream().filter(f -> f.getGroupId().equals(it.getId()))).collect(Collectors.toList());
        if (storage.requirePath()) {
            for (MagicEntity entity2 : entities) {
                String newMappingKey = storage.buildKey(entity2);
                if (!this.pathCache.get(src.getType()).entrySet().stream().anyMatch(entry -> ((String)entry.getValue()).equals(newMappingKey) && !((String)entry.getKey()).equals(entity2.getId()))) continue;
                src.setParentId(oldParentId);
                throw new InvalidArgumentException(MOVE_PATH_CONFLICT);
            }
        }
        src.setUpdateBy(WebUtils.currentUserName());
        src.setUpdateTime(System.currentTimeMillis());
        Resource oldResource = this.groupMappings.get(src.getId());
        if (oldResource.renameTo(targetResource) && (resource = targetResource.getResource("group.json")).write(JsonUtils.toJsonString(src))) {
            this.putGroup(src, targetResource);
            if (storage.requirePath()) {
                Map<String, String> selfPathCache = this.pathCache.get(storage.folder());
                entities.forEach(entity -> selfPathCache.put(entity.getId(), storage.buildKey((MagicEntity)entity)));
            }
            this.refreshGroup(targetResource, storage);
            this.publisher.publishEvent((Object)new GroupEvent(src.getType(), EventAction.MOVE, src, entities));
            return true;
        }
        return false;
    }

    private <T extends MagicEntity> boolean moveFile(T entity, Group group) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        this.isTrue(!"1".equals(entity.getLock()), RESOURCE_LOCKED);
        entity.setGroupId(group.getId());
        MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(group.getType());
        String newMappingKey = storage.buildKey(entity);
        Resource resource = this.groupMappings.get(group.getId());
        Resource newResource = resource.getResource(entity.getName() + storage.suffix());
        this.isTrue(!newResource.exists(), MOVE_NAME_CONFLICT);
        this.isTrue(!storage.requirePath() || this.pathCache.get(storage.folder()).entrySet().stream().noneMatch(entry -> ((String)entry.getValue()).equals(newMappingKey) && !((String)entry.getKey()).equals(entity.getId())), MOVE_PATH_CONFLICT);
        entity.setUpdateBy(WebUtils.currentUserName());
        entity.setUpdateTime(System.currentTimeMillis());
        if (newResource.write(storage.write(entity))) {
            this.fileMappings.remove(entity.getId()).delete();
            this.putFile(storage, entity, newResource);
            this.publisher.publishEvent((Object)new FileEvent(group.getType(), EventAction.MOVE, entity));
            return true;
        }
        return false;
    }

    @Override
    public TreeNode<Group> tree(String type) {
        return this.readLock(() -> this.groupCache.values().stream().filter(it -> type.equals(it.getType())).collect(Collectors.collectingAndThen(Collectors.toList(), this::convertToTree)));
    }

    @Override
    public Map<String, TreeNode<Group>> tree() {
        return this.readLock(() -> this.groupCache.values().stream().collect(Collectors.groupingBy(Group::getType, Collectors.collectingAndThen(Collectors.toList(), this::convertToTree))));
    }

    @Override
    public List<Group> getGroupsByFileId(String id) {
        return this.readLock(() -> {
            ArrayList<Group> groups = new ArrayList<Group>();
            MagicEntity entity = this.fileCache.get(id);
            if (entity != null) {
                Group group = this.groupCache.get(entity.getGroupId());
                while (group != null) {
                    groups.add(group);
                    group = this.groupCache.get(group.getParentId());
                }
            }
            return groups;
        });
    }

    private TreeNode<Group> convertToTree(List<Group> groups) {
        TreeNode<Group> root = new TreeNode<Group>();
        root.setNode(new Group("0", "root"));
        this.convertToTree(groups, root);
        return root;
    }

    private void convertToTree(List<Group> remains, TreeNode<Group> current) {
        LinkedList<TreeNode<TreeNode>> childNodes = new LinkedList<TreeNode<TreeNode>>();
        Iterator<Group> iterator = remains.iterator();
        while (iterator.hasNext()) {
            Group temp = iterator.next();
            if (!current.getNode().getId().equals(temp.getParentId())) continue;
            childNodes.add(new TreeNode<Group>(temp));
            iterator.remove();
        }
        current.setChildren(childNodes);
        childNodes.forEach(it -> this.convertToTree(remains, (TreeNode<Group>)it));
    }

    @Override
    public Resource getGroupResource(String id) {
        return this.groupMappings.get(id);
    }

    @Override
    public <T extends MagicEntity> boolean saveFile(T entity) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        this.notNull(entity.getGroupId(), GROUP_ID_REQUIRED);
        this.notBlank(entity.getName(), NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(entity.getName()), NAME_INVALID);
        return this.writeLock(() -> {
            MagicResourceStorage<? extends MagicEntity> storage;
            EventAction action = entity.getId() == null || !this.fileCache.containsKey(entity.getId()) ? EventAction.CREATE : EventAction.SAVE;
            Resource groupResource = this.getGroupResource(entity.getGroupId());
            this.notNull(groupResource, GROUP_NOT_FOUND);
            if (entity.getGroupId().contains(":")) {
                storage = this.storages.get(entity.getGroupId().split(":")[0]);
            } else {
                Group group = this.groupCache.get(entity.getGroupId());
                storage = this.storages.get(group.getType());
            }
            if (storage.requiredScript()) {
                this.notBlank(entity.getScript(), SCRIPT_REQUIRED);
            }
            if (storage.requirePath()) {
                this.notBlank(((PathMagicEntity)entity).getPath(), PATH_REQUIRED);
                String newMappingKey = storage.buildKey(entity);
                this.isTrue(this.pathCache.get(storage.folder()).entrySet().stream().noneMatch(entry -> ((String)entry.getValue()).equals(newMappingKey) && !((String)entry.getKey()).equals(entity.getId())), PATH_CONFLICT);
            }
            storage.validate(entity);
            String filename = entity.getName() + storage.suffix();
            Resource fileResource = groupResource.getResource(filename);
            if (action == EventAction.CREATE) {
                if (entity.getId() == null) {
                    this.isTrue(!fileResource.exists(), FILE_SAVE_FAILURE);
                    entity.setId(UUID.randomUUID().toString().replace("-", ""));
                }
                entity.setCreateTime(System.currentTimeMillis());
                entity.setCreateBy(WebUtils.currentUserName());
            } else {
                entity.setUpdateTime(System.currentTimeMillis());
                entity.setUpdateBy(WebUtils.currentUserName());
                this.isTrue(!"1".equals(this.fileCache.get(entity.getId()).getLock()), RESOURCE_LOCKED);
                Resource oldFileResource = this.fileMappings.get(entity.getId());
                if (!oldFileResource.name().equals(fileResource.name())) {
                    this.isTrue(oldFileResource.renameTo(fileResource), FILE_SAVE_FAILURE);
                }
            }
            boolean flag = fileResource.write(storage.write(entity));
            if (flag) {
                this.publisher.publishEvent((Object)new FileEvent(storage.folder(), action, entity));
                this.putFile(storage, entity, fileResource);
            }
            return flag;
        });
    }

    private List<MagicEntity> deleteGroup(String id) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        Group group = this.groupCache.get(id);
        ArrayList<MagicEntity> entities = new ArrayList<MagicEntity>();
        this.tree(group.getType()).findTreeNode(it -> it.getId().equals(id)).flat().forEach(g -> {
            this.groupCache.remove(g.getId());
            this.groupMappings.remove(g.getId());
            this.fileCache.values().stream().filter(f -> f.getGroupId().equals(g.getId())).peek(entities::add).collect(Collectors.toList()).forEach(file -> {
                this.fileCache.remove(file.getId());
                this.fileMappings.remove(file.getId());
                Map<String, String> map = this.pathCache.get(g.getType());
                if (map != null) {
                    map.remove(file.getId());
                }
            });
        });
        this.groupMappings.remove(id);
        this.groupCache.remove(id);
        return entities;
    }

    @Override
    public boolean delete(String id) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        return this.writeLock(() -> {
            Resource resource = this.getGroupResource(id);
            if (resource != null && resource.exists() && resource.delete()) {
                Group group = this.groupCache.get(id);
                GroupEvent event = new GroupEvent(this.groupCache.get(group.getId()).getType(), EventAction.DELETE, group);
                event.setEntities(this.deleteGroup(id));
                this.publisher.publishEvent((Object)event);
                return true;
            }
            resource = this.fileMappings.get(id);
            if (resource != null && resource.exists() && resource.delete()) {
                MagicEntity entity = this.fileCache.remove(id);
                String type = this.groupCache.get(entity.getGroupId()).getType();
                this.publisher.publishEvent((Object)new FileEvent(type, EventAction.DELETE, entity));
                this.fileMappings.remove(id);
                this.fileCache.remove(id);
                Map<String, String> map = this.pathCache.get(type);
                if (map != null) {
                    map.remove(id);
                }
            }
            return true;
        });
    }

    @Override
    public <T extends MagicEntity> List<T> listFiles(String groupId) {
        return this.readLock(() -> {
            Group group = this.groupCache.get(groupId);
            this.notNull(group, GROUP_NOT_FOUND);
            return this.fileCache.values().stream().filter(it -> it.getGroupId().equals(groupId)).map(it -> it).collect(Collectors.toList());
        });
    }

    @Override
    public <T extends MagicEntity> List<T> files(String type) {
        MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(type);
        Resource directory = this.root.getDirectory(type);
        if (directory.exists()) {
            return directory.files(storage.suffix()).stream().map(storage::readResource).map(it -> it).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends MagicEntity> T file(String id) {
        return (T)this.fileCache.get(id);
    }

    @Override
    public Group getGroup(String id) {
        return this.groupCache.get(id);
    }

    @Override
    public void export(String groupId, List<SelectedResource> resources, OutputStream os) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            Resource resource = this.getGroupResource(groupId);
            this.notNull(resource, GROUP_NOT_FOUND);
            resource.export(os, new String[0]);
        } else if (resources == null || resources.isEmpty()) {
            this.root.export(os, new String[0]);
        } else {
            ZipOutputStream zos = new ZipOutputStream(os);
            for (SelectedResource item : resources) {
                Resource resource;
                if ("root".equals(item.getType())) {
                    zos.putNextEntry(new ZipEntry(item.getId() + "/"));
                    continue;
                }
                if ("group".equals(item.getType())) {
                    resource = this.getGroupResource(item.getId());
                    this.notNull(resource, GROUP_NOT_FOUND);
                    zos.putNextEntry(new ZipEntry(resource.getFilePath()));
                    zos.closeEntry();
                    resource = resource.getResource("group.json");
                    zos.putNextEntry(new ZipEntry(resource.getFilePath()));
                    zos.write(resource.read());
                    zos.closeEntry();
                    continue;
                }
                resource = this.fileMappings.get(item.getId());
                MagicEntity entity = this.fileCache.get(item.getId());
                this.notNull(entity, FILE_NOT_FOUND);
                Resource groupResource = this.groupMappings.get(entity.getGroupId());
                Group group = this.groupCache.get(entity.getGroupId());
                MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(group.getType());
                zos.putNextEntry(new ZipEntry(groupResource.getFilePath() + entity.getName() + storage.suffix()));
                zos.write(resource.read());
                zos.closeEntry();
            }
            zos.flush();
            zos.close();
        }
    }

    @Override
    public boolean lock(String id) {
        return this.doLockResource(id, "1");
    }

    private boolean doLockResource(String id, String lockState) {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        return this.writeLock(() -> {
            MagicEntity entity = this.fileCache.get(id);
            Resource resource = this.fileMappings.get(id);
            this.notNull(entity, FILE_NOT_FOUND);
            this.notNull(resource, FILE_NOT_FOUND);
            Group group = this.groupCache.get(entity.getGroupId());
            this.notNull(group, GROUP_NOT_FOUND);
            entity.setLock(lockState);
            entity.setUpdateTime(System.currentTimeMillis());
            entity.setUpdateBy(WebUtils.currentUserName());
            MagicResourceStorage<? extends MagicEntity> storage = this.storages.get(group.getType());
            boolean flag = resource.write(storage.write(entity));
            if (flag) {
                this.putFile(storage, entity, resource);
            }
            return flag;
        });
    }

    @Override
    public boolean unlock(String id) {
        return this.doLockResource(id, "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upload(InputStream inputStream, boolean full) throws IOException {
        this.isTrue(!this.root.readonly(), IS_READ_ONLY);
        try {
            ZipResource zipResource = new ZipResource(inputStream);
            LinkedHashSet groups = new LinkedHashSet();
            LinkedHashSet entities = new LinkedHashSet();
            boolean bl = this.writeLock(() -> {
                this.readAllResource(zipResource, groups, entities, !full);
                if (full) {
                    this.root.delete();
                    this.init();
                    this.publisher.publishEvent((Object)new MagicEvent("clear", EventAction.CLEAR));
                }
                for (Group group : groups) {
                    this.saveGroup(group);
                }
                for (MagicEntity entity : entities) {
                    this.saveFile(entity);
                }
                return true;
            });
            return bl;
        }
        finally {
            IoUtils.close(inputStream);
        }
    }

    private void readAllResource(Resource root, Set<Group> groups, Set<MagicEntity> entities, boolean checked) {
        Resource resource = root.getResource("group.json");
        MagicResourceStorage<? extends MagicEntity> storage = null;
        if (resource.exists()) {
            Group group = JsonUtils.readValue(resource.read(), Group.class);
            group.setType(this.mappingV1Type(group.getType()));
            storage = this.storages.get(group.getType());
            this.notNull(storage, NOT_SUPPORTED_GROUP_TYPE);
        }
        this.readAllResource(root, storage, groups, entities, null, "/", checked);
    }

    private void readAllResource(Resource root, MagicResourceStorage<? extends MagicEntity> storage, Set<Group> groups, Set<MagicEntity> entities, Set<String> mappingKeys, String path, boolean checked) {
        MagicResourceStorage<? extends MagicEntity> magicResourceStorage = storage = storage == null ? this.storages.get(root.name()) : storage;
        if (storage != null) {
            Resource resource;
            HashSet<String> hashSet = mappingKeys = mappingKeys == null ? new HashSet<String>() : mappingKeys;
            if (!storage.allowRoot() && (resource = root.getResource("group.json")).exists()) {
                Group group = JsonUtils.readValue(resource.read(), Group.class);
                group.setType(this.mappingV1Type(group.getType()));
                groups.add(group);
                if (storage.requirePath()) {
                    path = path + Objects.toString(group.getPath(), "") + "/";
                }
            }
            for (Resource file : root.files(storage.suffix())) {
                MagicEntity entity = storage.read(file.read());
                if (storage.allowRoot()) {
                    entity.setGroupId(storage.folder() + ":0");
                }
                String mappingKey = storage instanceof AbstractPathMagicResourceStorage ? ((AbstractPathMagicResourceStorage)storage).buildMappingKey((PathMagicEntity)entity, path) : storage.buildKey(entity);
                if (checked) {
                    String groupId = entity.getGroupId();
                    this.fileCache.values().stream().filter(it -> Objects.equals(it.getGroupId(), groupId)).filter(it -> !it.getId().equals(entity.getId())).forEach(it -> this.isTrue(!Objects.equals(it.getName(), entity.getName()), RESOURCE_PATH_CONFLICT.format(entity.getName())));
                }
                this.isTrue(mappingKeys.add(mappingKey), RESOURCE_PATH_CONFLICT.format(mappingKey));
                entities.add(entity);
            }
        }
        for (Resource directory : root.dirs()) {
            this.readAllResource(directory, storage, groups, entities, mappingKeys, path, checked);
        }
    }

    private String mappingV1Type(String type) {
        if ("1".equals(type)) {
            return "api";
        }
        if ("2".equals(type)) {
            return "function";
        }
        return type;
    }

    @Override
    public String getGroupName(String groupId) {
        return this.findGroups(groupId).stream().map(Group::getName).collect(Collectors.joining("/"));
    }

    @Override
    public String getGroupPath(String groupId) {
        return this.findGroups(groupId).stream().map(Group::getPath).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
    }

    private List<Group> findGroups(String groupId) {
        return this.readLock(() -> {
            ArrayList<Group> groups = new ArrayList<Group>();
            String key = groupId;
            while (this.groupCache.containsKey(key)) {
                Group group = this.groupCache.get(key);
                groups.add(0, group);
                key = group.getParentId();
            }
            return groups;
        });
    }

    private void putGroup(Group group, Resource resource) {
        this.groupMappings.put(group.getId(), resource);
        this.groupCache.put(group.getId(), group);
    }

    private void putFile(MagicResourceStorage<?> storage, MagicEntity entity, Resource resource) {
        this.fileMappings.put(entity.getId(), resource);
        this.fileCache.put(entity.getId(), entity);
        if (storage.requirePath()) {
            this.pathCache.get(storage.folder()).put(entity.getId(), storage.buildKey(entity));
        }
    }

    private <R> R readLock(Supplier<R> supplier) {
        try {
            this.lock.readLock().lock();
            R r = supplier.get();
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private <R> R writeLock(Supplier<R> supplier) {
        try {
            this.lock.writeLock().lock();
            R r = supplier.get();
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        try {
            this.read(false);
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }
}

