/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.exception.InvalidArgumentException;
import org.ssssssss.magicapi.core.interceptor.Authorization;
import org.ssssssss.magicapi.core.model.Attributes;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.JsonBean;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.model.TreeNode;
import org.ssssssss.magicapi.core.resource.FileResource;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.core.service.MagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.servlet.MagicHttpServletRequest;
import org.ssssssss.magicapi.core.web.MagicController;
import org.ssssssss.magicapi.core.web.MagicExceptionHandler;
import org.ssssssss.magicapi.utils.IoUtils;

public class MagicResourceController
extends MagicController
implements MagicExceptionHandler {
    private final MagicResourceService service = MagicConfiguration.getMagicResourceService();

    public MagicResourceController(MagicConfiguration configuration) {
        super(configuration);
    }

    @PostMapping(value={"/resource/folder/save"})
    @ResponseBody
    public JsonBean<String> saveFolder(@RequestBody Group group, MagicHttpServletRequest request) {
        this.isTrue(this.allowVisit(request, Authorization.SAVE, group), PERMISSION_INVALID);
        Resource resource = this.service.getResource();
        if (resource instanceof FileResource) {
            this.isTrue(resource.exists(), FILE_PATH_NOT_EXISTS);
        }
        if (this.service.saveGroup(group)) {
            return new JsonBean<String>(group.getId());
        }
        return new JsonBean<String>((String)null);
    }

    @PostMapping(value={"/resource/folder/copy"})
    @ResponseBody
    public JsonBean<String> saveFolder(String src, String target, MagicHttpServletRequest request) {
        Group srcGroup = this.service.getGroup(src);
        this.notNull(srcGroup, GROUP_NOT_FOUND);
        this.isTrue(this.allowVisit(request, Authorization.VIEW, srcGroup), PERMISSION_INVALID);
        Group targetGroup = srcGroup.copy();
        targetGroup.setId(null);
        targetGroup.setParentId(target);
        targetGroup.setType(srcGroup.getType());
        this.isTrue(this.allowVisit(request, Authorization.SAVE, targetGroup), PERMISSION_INVALID);
        return new JsonBean<String>(this.service.copyGroup(src, target));
    }

    @PostMapping(value={"/resource/delete"})
    @ResponseBody
    public JsonBean<Boolean> delete(String id, MagicHttpServletRequest request) {
        Group group = this.service.getGroup(id);
        if (group == null) {
            Object entity = this.service.file(id);
            this.notNull(entity, FILE_NOT_FOUND);
            this.isTrue(this.allowVisit(request, Authorization.DELETE, (MagicEntity)entity), PERMISSION_INVALID);
        } else {
            this.isTrue(this.allowVisit(request, Authorization.DELETE, group), PERMISSION_INVALID);
        }
        return new JsonBean<Boolean>(this.service.delete(id));
    }

    @PostMapping(value={"/resource/file/{folder}/save"})
    @ResponseBody
    public JsonBean<String> saveFile(@PathVariable(value="folder") String folder, String auto, MagicHttpServletRequest request) throws IOException {
        Object oldInfo;
        byte[] bytes = IoUtils.bytes(request.getInputStream());
        Object entity = this.configuration.getMagicDynamicRegistries().stream().map(MagicDynamicRegistry::getMagicResourceStorage).filter(it -> Objects.equals(it.folder(), folder)).findFirst().orElseThrow(() -> new InvalidArgumentException(GROUP_NOT_FOUND)).read(bytes);
        this.isTrue(this.allowVisit(request, Authorization.SAVE, (MagicEntity)entity), PERMISSION_INVALID);
        if (((MagicEntity)entity).getId() != null && "1".equals(auto) && (oldInfo = this.service.file(((MagicEntity)entity).getId())) != null && Objects.equals(oldInfo, entity)) {
            return new JsonBean<String>(((MagicEntity)entity).getId());
        }
        if (MagicConfiguration.getMagicResourceService().saveFile(entity)) {
            return new JsonBean<String>(((MagicEntity)entity).getId());
        }
        return new JsonBean<String>(null);
    }

    @GetMapping(value={"/resource/file/{id}"})
    @ResponseBody
    public JsonBean<MagicEntity> detail(@PathVariable(value="id") String id, MagicHttpServletRequest request) {
        Object entity = MagicConfiguration.getMagicResourceService().file(id);
        this.isTrue(this.allowVisit(request, Authorization.VIEW, (MagicEntity)entity), PERMISSION_INVALID);
        return new JsonBean<MagicEntity>((MagicEntity)MagicConfiguration.getMagicResourceService().file(id));
    }

    @PostMapping(value={"/resource/move"})
    @ResponseBody
    public JsonBean<Boolean> move(String src, String groupId, MagicHttpServletRequest request) {
        Group group = this.service.getGroup(src);
        if (group == null) {
            Object entity = this.service.file(src);
            this.notNull(entity, FILE_NOT_FOUND);
            entity = ((MagicEntity)entity).copy();
            ((MagicEntity)entity).setGroupId(groupId);
            this.isTrue(this.allowVisit(request, Authorization.SAVE, (MagicEntity)entity), PERMISSION_INVALID);
        } else {
            group = group.copy();
            group.setParentId(groupId);
            this.isTrue(this.allowVisit(request, Authorization.DELETE, group), PERMISSION_INVALID);
        }
        return new JsonBean<Boolean>(this.service.move(src, groupId));
    }

    @PostMapping(value={"/resource/lock"})
    @ResponseBody
    public JsonBean<Boolean> lock(String id, MagicHttpServletRequest request) {
        Object entity = this.service.file(id);
        this.notNull(entity, FILE_NOT_FOUND);
        this.isTrue(this.allowVisit(request, Authorization.LOCK, (MagicEntity)entity), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.service.lock(id));
    }

    @PostMapping(value={"/resource/unlock"})
    @ResponseBody
    public JsonBean<Boolean> unlock(String id, MagicHttpServletRequest request) {
        Object entity = this.service.file(id);
        this.notNull(entity, FILE_NOT_FOUND);
        this.isTrue(this.allowVisit(request, Authorization.UNLOCK, (MagicEntity)entity), PERMISSION_INVALID);
        return new JsonBean<Boolean>(this.service.unlock(id));
    }

    @GetMapping(value={"/resource"})
    @ResponseBody
    public JsonBean<Map<String, TreeNode<Attributes<Object>>>> resources(MagicHttpServletRequest request) {
        Map<String, TreeNode<Group>> tree = this.service.tree();
        HashMap result = new HashMap();
        tree.forEach((key, value) -> {
            TreeNode<Attributes<Object>> node = this.process((TreeNode<Group>)value, request);
            List<TreeNode<Attributes<Object>>> groups = node.getChildren();
            if (groups.size() > 0) {
                List<TreeNode<Attributes<Object>>> nodes = groups.get(0).getChildren();
                this.configuration.getMagicDynamicRegistries().stream().filter(it -> it.getMagicResourceStorage().folder().equals(key)).findFirst().map(MagicDynamicRegistry::defaultMappings).ifPresent(mappings -> {
                    for (MagicEntity mapping : mappings) {
                        nodes.add(new TreeNode<MagicEntity>(mapping));
                    }
                });
            }
            result.put(key, node);
        });
        return new JsonBean<Map<String, TreeNode<Attributes<Object>>>>(result);
    }

    private TreeNode<Attributes<Object>> process(TreeNode<Group> groupNode, MagicHttpServletRequest request) {
        TreeNode<Attributes<Object>> value = new TreeNode<Attributes<Object>>();
        value.setNode(groupNode.getNode());
        groupNode.getChildren().stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (Group)it.getNode())).map(it -> this.process((TreeNode<Group>)it, request)).forEach(value::addChild);
        if (!"0".equals(groupNode.getNode().getId())) {
            this.service.listFiles(groupNode.getNode().getId()).stream().filter(it -> this.allowVisit(request, Authorization.VIEW, (MagicEntity)it)).map(MagicEntity::simple).map(TreeNode::new).forEach(value::addChild);
        }
        return value;
    }
}

