/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.inteceptor;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.modules.db.BoundSql;
import org.ssssssss.magicapi.modules.db.inteceptor.SQLInterceptor;

public class DefaultSqlInterceptor
implements SQLInterceptor {
    private void handleLog(BoundSql boundSql, RequestEntity requestEntity) {
        Logger logger = LoggerFactory.getLogger((String)(requestEntity == null ? "Unknown" : requestEntity.getMagicScriptContext().getScriptName()));
        String parameters = Arrays.stream(boundSql.getParameters()).map(it -> {
            if (it == null) {
                return "null";
            }
            return it + "(" + it.getClass().getSimpleName() + ")";
        }).collect(Collectors.joining(", "));
        String dataSourceName = boundSql.getSqlModule().getDataSourceName();
        logger.info("\u6267\u884cSQL\uff1a{}", (Object)boundSql.getSql().trim());
        if (dataSourceName != null) {
            logger.info("\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceName);
        }
        if (parameters.length() > 0) {
            logger.info("SQL\u53c2\u6570\uff1a{}", (Object)parameters);
        }
    }

    @Override
    public Object postHandle(BoundSql boundSql, Object result, RequestEntity requestEntity) {
        this.handleLog(boundSql, requestEntity);
        return result;
    }

    @Override
    public void handleException(BoundSql boundSql, Throwable throwable, RequestEntity requestEntity) {
        this.handleLog(boundSql, requestEntity);
    }
}

