/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.provider;

import java.util.Objects;
import org.apache.commons.lang3.math.NumberUtils;
import org.ssssssss.magicapi.modules.db.model.Page;
import org.ssssssss.magicapi.modules.db.provider.PageProvider;
import org.ssssssss.script.runtime.RuntimeContext;

public class DefaultPageProvider
implements PageProvider {
    private final String pageName;
    private final String pageSize;
    private final long defaultPageSize;
    private final long defaultPage;
    private final long maxPageSize;

    public DefaultPageProvider(String pageName, String pageSize, long defaultPage, long defaultPageSize, long maxPageSize) {
        this.pageName = pageName;
        this.pageSize = pageSize;
        this.defaultPageSize = defaultPageSize;
        this.defaultPage = defaultPage;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public Page getPage(RuntimeContext context) {
        long page = NumberUtils.toLong((String)Objects.toString(context.eval(this.pageName), null), (long)this.defaultPage);
        long pageSize = NumberUtils.toLong((String)Objects.toString(context.eval(this.pageSize), null), (long)this.defaultPageSize);
        if (this.maxPageSize > 0L) {
            pageSize = Math.min(pageSize, this.maxPageSize);
        }
        return new Page(pageSize, (page - 1L) * pageSize);
    }
}

