/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.handler;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.ssssssss.magicapi.core.annotation.Message;
import org.ssssssss.magicapi.core.config.MessageType;
import org.ssssssss.magicapi.core.config.WebSocketSessionManager;
import org.ssssssss.magicapi.core.context.MagicConsoleSession;
import org.ssssssss.magicapi.core.context.MagicUser;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.utils.IpUtils;

public class MagicWorkbenchHandler {
    private final AuthorizationInterceptor authorizationInterceptor;
    private static final MagicUser guest = new MagicUser("guest", "\u6e38\u5ba2", "unauthorization");
    private static final Logger logger = LoggerFactory.getLogger(MagicWorkbenchHandler.class);

    public MagicWorkbenchHandler(AuthorizationInterceptor authorizationInterceptor) {
        this.authorizationInterceptor = authorizationInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Message(value=MessageType.LOGIN)
    public void onLogin(MagicConsoleSession session, String token, String clientId) {
        MagicUser user;
        block10: {
            session.setClientId(clientId);
            user = null;
            try {
                user = this.authorizationInterceptor.getUserByToken(token);
            }
            catch (Exception e) {
                if (this.authorizationInterceptor.requireLogin()) break block10;
                user = guest;
            }
        }
        if (user != null) {
            String ip = Optional.ofNullable(session.getWebSocketSession().getRemoteAddress()).map(it -> it.getAddress().getHostAddress()).orElse("unknown");
            HttpHeaders headers = session.getWebSocketSession().getHandshakeHeaders();
            ip = IpUtils.getRealIP(ip, arg_0 -> ((HttpHeaders)headers).getFirst(arg_0), null);
            if (user.getTimeout() > 0L) {
                session.setUser(user);
                session.setTimeout(user.getTimeout() * 1000L + System.currentTimeMillis());
            }
            session.setAttribute("id", user.getId());
            session.setAttribute("ip", StringUtils.defaultIfBlank((CharSequence)ip, (CharSequence)"unknown"));
            session.setAttribute("username", user.getUsername());
            session.setActivateTime(System.currentTimeMillis());
            Class<MagicWorkbenchHandler> clazz = MagicWorkbenchHandler.class;
            synchronized (MagicWorkbenchHandler.class) {
                if (WebSocketSessionManager.getConsoleSession(clientId) != null) {
                    WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.LOGIN_RESPONSE, "-1"));
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return;
                }
                WebSocketSessionManager.add(session);
                // ** MonitorExit[var7_8] (shouldn't be in output)
                WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.LOGIN_RESPONSE, "1", session.getAttributes()));
                List<Map<String, Object>> messages = this.getOnlineUsers();
                if (!messages.isEmpty()) {
                    WebSocketSessionManager.sendByClientId(session.getClientId(), WebSocketSessionManager.buildMessage(MessageType.ONLINE_USERS, messages));
                }
                WebSocketSessionManager.sendToMachine(MessageType.SEND_ONLINE, session.getClientId());
                WebSocketSessionManager.sendToOther(session.getClientId(), MessageType.USER_LOGIN, session.getAttributes());
            }
        } else {
            WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.LOGIN_RESPONSE, "0"));
        }
    }

    @Message(value=MessageType.SEND_ONLINE)
    public void sendOnline(String clientId) {
        List<Map<String, Object>> messages = this.getOnlineUsers();
        if (!messages.isEmpty()) {
            WebSocketSessionManager.sendToMachineByClientId(clientId, WebSocketSessionManager.buildMessage(MessageType.ONLINE_USERS, messages));
        }
    }

    @Message(value=MessageType.PONG)
    public String pong(MagicConsoleSession session) {
        session.setActivateTime(System.currentTimeMillis());
        MagicUser user = session.getUser();
        if (user != null && session.getTimeout() - System.currentTimeMillis() < 60000L) {
            String oldToken = user.getToken();
            this.authorizationInterceptor.refreshToken(user);
            String newToken = user.getToken();
            session.setTimeout(System.currentTimeMillis() + user.getTimeout() * 1000L);
            if (!Objects.equals(newToken, oldToken)) {
                WebSocketSessionManager.sendBySession(session, WebSocketSessionManager.buildMessage(MessageType.REFRESH_TOKEN, newToken));
            }
        }
        return null;
    }

    private List<Map<String, Object>> getOnlineUsers() {
        return WebSocketSessionManager.getSessions().stream().map(MagicConsoleSession::getAttributes).collect(Collectors.toList());
    }
}

