/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.context.event.EventListener;
import org.ssssssss.magicapi.core.event.EventAction;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.event.MagicEvent;
import org.ssssssss.magicapi.core.exception.MagicAPIException;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.service.MagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;

public abstract class AbstractMagicDynamicRegistry<T extends MagicEntity>
implements MagicDynamicRegistry<T> {
    private final Map<String, MappingNode<T>> mappings = new ConcurrentHashMap<String, MappingNode<T>>();
    protected final MagicResourceStorage<T> magicResourceStorage;

    public AbstractMagicDynamicRegistry(MagicResourceStorage<T> magicResourceStorage) {
        this.magicResourceStorage = magicResourceStorage;
    }

    @Override
    public boolean register(T entity) {
        MappingNode<T> mappingNode = this.buildMappingNode(entity);
        String newMappingKey = mappingNode.getMappingKey();
        MappingNode<T> oldMappingNode = this.mappings.get(((MagicEntity)entity).getId());
        if (oldMappingNode != null) {
            String oldMappingKey = oldMappingNode.getMappingKey();
            if (Objects.equals(oldMappingKey, newMappingKey)) {
                if (!((MagicEntity)entity).equals(oldMappingNode.getEntity())) {
                    oldMappingNode.setEntity(entity);
                }
                return true;
            }
            this.mappings.remove(oldMappingKey);
            this.mappings.remove(((MagicEntity)entity).getId());
            this.unregister(oldMappingNode);
        } else if (this.mappings.containsKey(newMappingKey)) {
            throw new MagicAPIException(newMappingKey + " \u5df2\u6ce8\u518c\uff0c\u8bf7\u66f4\u6362\u540d\u79f0\u6216\u8def\u5f84");
        }
        if (this.register(mappingNode)) {
            this.mappings.put(((MagicEntity)entity).getId(), mappingNode);
            this.mappings.put(newMappingKey, mappingNode);
            return true;
        }
        return false;
    }

    @EventListener(condition="#event.action == T(org.ssssssss.magicapi.core.event.EventAction).CLEAR")
    public void clear(MagicEvent event) {
        Iterator<Map.Entry<String, MappingNode<T>>> iterator = this.mappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MappingNode<T>> entry = iterator.next();
            if (Objects.equals(entry.getKey(), ((MagicEntity)entry.getValue().getEntity()).getId())) {
                this.unregister(entry.getValue());
            }
            iterator.remove();
        }
    }

    protected void processEvent(FileEvent event) {
        MagicEntity info = event.getEntity();
        if (event.getAction() == EventAction.DELETE) {
            this.unregister(info);
        } else {
            this.register(info);
        }
    }

    protected void processEvent(GroupEvent event) {
        if (event.getAction() == EventAction.DELETE) {
            event.getEntities().forEach(entity -> this.unregister(entity));
        } else {
            event.getEntities().forEach(entity -> this.register(entity));
        }
    }

    @Override
    public T getMapping(String mappingKey) {
        MappingNode<T> node = this.mappings.get(mappingKey);
        return node == null ? null : (T)node.getEntity();
    }

    @Override
    public boolean unregister(T entity) {
        MappingNode<T> mappingNode = this.mappings.remove(((MagicEntity)entity).getId());
        if (mappingNode != null) {
            this.mappings.remove(mappingNode.getMappingKey());
            this.unregister(mappingNode);
            return true;
        }
        return false;
    }

    @Override
    public MagicResourceStorage<T> getMagicResourceStorage() {
        return this.magicResourceStorage;
    }

    @Override
    protected boolean register(MappingNode<T> mappingNode) {
        return true;
    }

    protected void unregister(MappingNode<T> mappingNode) {
    }

    public List<T> mappings() {
        return this.mappings.values().stream().map(MappingNode::getEntity).collect(Collectors.toList());
    }

    protected MappingNode<T> buildMappingNode(T entity) {
        MappingNode<T> mappingNode = new MappingNode<T>(entity);
        mappingNode.setMappingKey(this.magicResourceStorage.buildKey((MagicEntity)entity));
        return mappingNode;
    }

    protected static class MappingNode<T extends MagicEntity> {
        private T entity;
        private String mappingKey = "";
        private Object mappingData;

        public MappingNode(T entity) {
            this.entity = entity;
        }

        public T getEntity() {
            return this.entity;
        }

        public void setEntity(T entity) {
            this.entity = entity;
        }

        public String getMappingKey() {
            return this.mappingKey;
        }

        public void setMappingKey(String mappingKey) {
            this.mappingKey = mappingKey;
        }

        public Object getMappingData() {
            return this.mappingData;
        }

        public void setMappingData(Object mappingData) {
            this.mappingData = mappingData;
        }
    }
}

