/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.runtime.Variables;

public class MagicScriptDebugContext
extends MagicScriptContext {
    private final BlockingQueue<String> producer = new LinkedBlockingQueue<String>();
    private final BlockingQueue<String> consumer = new LinkedBlockingQueue<String>();
    public List<Integer> breakpoints;
    private String id = UUID.randomUUID().toString().replace("-", "");
    private Consumer<Map<String, Object>> callback;
    private int[] line;
    private int timeout = 60;
    private boolean stepInto = false;

    public MagicScriptDebugContext(List<Integer> breakpoints) {
        this.breakpoints = breakpoints;
    }

    public void setCallback(Consumer<Map<String, Object>> callback) {
        this.callback = callback;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setBreakpoints(List<Integer> breakpoints) {
        this.breakpoints = breakpoints;
    }

    @Override
    public synchronized void pause(int startRow, int startCol, int endRow, int endCol, Variables variables) throws InterruptedException {
        if (this.stepInto || this.breakpoints.contains(startRow)) {
            this.line = new int[]{startRow, startCol, endRow, endCol};
            this.consumer.offer(this.id);
            LinkedHashMap<String, Object> varMap = new LinkedHashMap<String, Object>(this.getRootVariables());
            varMap.putAll(variables.getVariables(this));
            this.callback.accept(this.getDebugInfo(varMap));
            this.producer.poll(this.timeout, TimeUnit.SECONDS);
        }
    }

    public void await() throws InterruptedException {
        this.consumer.take();
    }

    public void singal() throws InterruptedException {
        this.producer.offer(this.id);
        this.await();
    }

    public void setStepInto(boolean stepInto) {
        this.stepInto = stepInto;
    }

    private Map<String, Object> getDebugInfo(Map<String, Object> variables) {
        ArrayList varList = new ArrayList();
        Set<Map.Entry<String, Object>> entries = variables.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object value = entry.getValue();
            HashMap<String, Object> variable = new HashMap<String, Object>();
            variable.put("name", entry.getKey());
            if (value != null) {
                variable.put("value", value);
                variable.put("type", value.getClass());
            } else {
                variable.put("value", "null");
            }
            varList.add(variable);
        }
        Collections.reverse(varList);
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("variables", varList);
        info.put("range", this.line);
        return info;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

