/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.statement.MemberAccess;
import org.ssssssss.script.parsing.ast.statement.Spread;

public class FunctionCall
extends Expression {
    private final Expression function;
    private final List<Expression> arguments;
    private final boolean inLinq;

    public FunctionCall(Span span, Expression function, List<Expression> arguments, boolean inLinq) {
        super(span);
        this.function = function;
        this.arguments = arguments;
        this.inLinq = inLinq;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.function.visitMethod(compiler);
        this.arguments.forEach(it -> it.visitMethod(compiler));
    }

    public Expression getFunction() {
        return this.function;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        int size = this.arguments.size();
        compiler.newRuntimeContext().ldc(this.getFunction().getSpan().getText()).insn(this.arguments.stream().anyMatch(it -> it instanceof Spread) ? 4 : 3).asBoolean().visitInt(size).typeInsn(189, Object.class);
        for (int i = 0; i < size; ++i) {
            Expression argument = this.arguments.get(i);
            compiler.insn(89).visitInt(i);
            if (this.inLinq && argument instanceof MemberAccess) {
                ((MemberAccess)argument).compileLinq(compiler);
            } else {
                compiler.visit(argument);
            }
            compiler.insn(83);
        }
        compiler.visit(this.function).lineNumber(this.getSpan()).call("invoke_function", 5);
    }
}

