/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.List;
import org.ssssssss.script.asm.Label;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Node;
import org.ssssssss.script.runtime.handle.OperatorHandle;

public class IfStatement
extends Node {
    private final Expression condition;
    private final List<Node> trueBlock;
    private final List<IfStatement> elseIfs;
    private final List<Node> falseBlock;

    public IfStatement(Span span, Expression condition, List<Node> trueBlock, List<IfStatement> elseIfs, List<Node> falseBlock) {
        super(span);
        this.condition = condition;
        this.trueBlock = trueBlock;
        this.elseIfs = elseIfs;
        this.falseBlock = falseBlock;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.condition.visitMethod(compiler);
        this.trueBlock.forEach(it -> it.visitMethod(compiler));
        this.elseIfs.forEach(it -> it.visitMethod(compiler));
        this.falseBlock.forEach(it -> it.visitMethod(compiler));
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        Label end = new Label();
        Label next = new Label();
        compiler.visit(this.condition).invoke(184, OperatorHandle.class, "isTrue", Boolean.TYPE, Object.class).jump(153, next).compile(this.trueBlock).jump(167, end);
        for (IfStatement elseIf : this.elseIfs) {
            compiler.label(next).visit(elseIf.condition).invoke(184, OperatorHandle.class, "isTrue", Boolean.TYPE, Object.class);
            next = new Label();
            compiler.jump(153, next).compile(elseIf.trueBlock).jump(167, end);
        }
        compiler.label(next);
        if (!this.falseBlock.isEmpty()) {
            compiler.compile(this.falseBlock);
        }
        compiler.label(end);
    }
}

