/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.ArrayList;
import java.util.List;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.statement.VariableDefine;

public class VariableDestructuringDefine
extends VariableDefine {
    private final List<VariableDefine> defines;
    private final Expression right;
    private final boolean mapAccess;

    public VariableDestructuringDefine(Span span, int size, Expression right, boolean mapAccess) {
        super(span, null, null);
        this.defines = new ArrayList<VariableDefine>(size);
        this.right = right;
        this.mapAccess = mapAccess;
    }

    public void add(VariableDefine variableDefine) {
        this.defines.add(variableDefine);
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        if (this.right != null) {
            this.right.visitMethod(compiler);
        }
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        compiler.visit(this.right).store(4);
        int size = this.defines.size();
        for (int i = 0; i < size; ++i) {
            VariableDefine define = this.defines.get(i);
            compiler.pre_store(define.getVarIndex());
            if (this.mapAccess) {
                compiler.newRuntimeContext().load4().ldc(define.getVarIndex().getName()).insn(4).asBoolean().insn(3).asBoolean().call("member_access", 5);
            } else {
                compiler.load4().visitInt(i).asInteger().operator("map_or_array_access");
            }
            compiler.scopeStore();
        }
    }
}

