/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.runtime.handle;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ssssssss.script.exception.MagicScriptRuntimeException;
import org.ssssssss.script.functions.ClassExtension;
import org.ssssssss.script.functions.DynamicAttribute;
import org.ssssssss.script.functions.DynamicMethod;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.parsing.ast.statement.AsyncCall;
import org.ssssssss.script.parsing.ast.statement.ClassConverter;
import org.ssssssss.script.reflection.JavaInvoker;
import org.ssssssss.script.reflection.JavaReflection;
import org.ssssssss.script.reflection.MethodInvoker;
import org.ssssssss.script.runtime.RuntimeContext;
import org.ssssssss.script.runtime.SpreadValue;
import org.ssssssss.script.runtime.Variables;
import org.ssssssss.script.runtime.function.MagicScriptLambdaFunction;
import org.ssssssss.script.runtime.handle.MethodCallSite;
import org.ssssssss.script.runtime.lang.ArrayKeyValueIterator;
import org.ssssssss.script.runtime.lang.ArrayValueIterator;
import org.ssssssss.script.runtime.lang.KeyValueIterator;
import org.ssssssss.script.runtime.lang.MapKeyValueIterator;

public class FunctionCallHandle {
    private static final MethodHandle FALLBACK;
    private static final MethodHandle INVOKE_METHOD;
    private static final MethodHandle INVOKE_FUNCTION;
    private static final MethodHandle MEMBER_ACCESS;
    private static final MethodHandle INVOKE_NEW_INSTANCE;
    private static final MethodHandle SET_VARIABLE_VALUE;
    private static final Object[] EMPTY_ARGS;

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type, int flag) {
        MethodCallSite callSite = new MethodCallSite(caller, name, type, FunctionCallHandle.class);
        MethodHandle fallback = null;
        switch (name) {
            case "invoke_method": {
                fallback = INVOKE_METHOD;
                break;
            }
            case "invoke_function": {
                fallback = INVOKE_FUNCTION;
                break;
            }
            case "member_access": {
                fallback = MEMBER_ACCESS;
                break;
            }
            case "invoke_new_instance": {
                fallback = INVOKE_NEW_INSTANCE;
                break;
            }
            case "set_variable_value": {
                fallback = SET_VARIABLE_VALUE;
            }
        }
        if (fallback != null) {
            fallback = fallback.asType(type);
            callSite.setTarget(fallback);
            callSite.fallback = fallback;
        } else {
            fallback = FALLBACK.bindTo(callSite).asCollector(Object[].class, type.parameterCount()).asType(type);
            callSite.setTarget(fallback);
            callSite.fallback = fallback;
        }
        return callSite;
    }

    public static Object fallback(MethodCallSite callSite, Object[] args) throws Throwable {
        JavaInvoker<Method> method = JavaReflection.getMethod(FunctionCallHandle.class, callSite.methodName, args);
        if (method != null) {
            return method.invoke0(null, null, args);
        }
        return null;
    }

    public static Object invoke_function(RuntimeContext runtimeContext, String name, boolean hasSpread, Object[] args, Object target) throws Throwable {
        JavaInvoker<Method> method = null;
        if (hasSpread) {
            args = FunctionCallHandle.do_spread(args);
        }
        if (args != null) {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                if (!(args[i] instanceof MagicScriptLambdaFunction)) continue;
                MagicScriptLambdaFunction function = (MagicScriptLambdaFunction)args[i];
                args[i] = objects -> function.apply(runtimeContext.getVariables(), (Object[])objects);
            }
        }
        if (target == null) {
            method = JavaReflection.getFunction(name, args);
        } else {
            if (target instanceof MagicScriptLambdaFunction) {
                return ((MagicScriptLambdaFunction)target).apply(runtimeContext.getVariables(), args);
            }
            if (target instanceof Function) {
                return ((Function)target).apply(args);
            }
        }
        if (method != null) {
            return method.invoke0(target, runtimeContext, args);
        }
        throw new NoSuchMethodException(String.format("\u627e\u4e0d\u5230\u51fd\u6570%s(%s)", name, String.join((CharSequence)",", JavaReflection.getStringTypes(args))));
    }

    public static Object invoke_method(RuntimeContext runtimeContext, String name, boolean hasSpread, boolean optional, Object[] args, Object target) throws Throwable {
        if (target == null && optional) {
            return null;
        }
        if (hasSpread) {
            args = FunctionCallHandle.do_spread(args);
        }
        if (target == null) {
            throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (target instanceof MagicScriptLambdaFunction) {
            return ((MagicScriptLambdaFunction)target).apply(runtimeContext.getVariables(), args);
        }
        if (target instanceof Function) {
            return ((Function)target).apply(args);
        }
        JavaInvoker<Method> method = JavaReflection.getMethod(target, name, args);
        if (method != null) {
            return method.invoke0(target, runtimeContext, args);
        }
        if (target instanceof DynamicMethod) {
            MethodInvoker invoker = new MethodInvoker(DynamicMethod.class.getDeclaredMethod("execute", String.class, List.class));
            Object[] newArgumentValues = new Object[]{name, Arrays.asList(args)};
            return invoker.invoke0(target, runtimeContext, newArgumentValues);
        }
        try {
            Object function = FunctionCallHandle.member_access(runtimeContext, target, name, optional, false);
            if (function != null) {
                return FunctionCallHandle.invoke_function(runtimeContext, name, false, args, function);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new NoSuchMethodException(String.format("\u5728%s\u4e2d\u627e\u4e0d\u5230\u65b9\u6cd5%s(%s)", target.getClass().getName(), name, String.join((CharSequence)",", JavaReflection.getStringTypes(args))));
    }

    public static Object spread(List<Object> source, List<Object> target) {
        source.addAll(target);
        return source;
    }

    public static Object spread(Map<Object, Object> source, Map<Object, Object> target) {
        source.putAll(target);
        return source;
    }

    public static Object member_access(RuntimeContext runtimeContext, Object target, String name, boolean optional, boolean inLinq) {
        if (target == null) {
            if (optional) {
                return null;
            }
            throw new NullPointerException("target is null");
        }
        if ("class".equals(name)) {
            return target instanceof Class ? target : target.getClass();
        }
        if (target instanceof Map) {
            return ((Map)((Object)target)).get(name);
        }
        if (target instanceof DynamicAttribute) {
            return ((DynamicAttribute)((Object)target)).getDynamicAttribute(name);
        }
        Field field = JavaReflection.getField(target, name);
        if (field != null) {
            return JavaReflection.getFieldValue(target, field);
        }
        Object innerClass = JavaReflection.getInnerClass(target, name);
        if (innerClass != null) {
            return innerClass;
        }
        String methodName = name.length() > 1 ? name.substring(0, 1).toUpperCase() + name.substring(1) : name.toUpperCase();
        JavaInvoker<Method> invoker = JavaReflection.getMethod(target, "get" + methodName, EMPTY_ARGS);
        try {
            if (invoker != null) {
                return invoker.invoke0(target, runtimeContext, EMPTY_ARGS);
            }
            invoker = JavaReflection.getMethod(target, "is" + methodName, EMPTY_ARGS);
            if (invoker != null) {
                return invoker.invoke0(target, runtimeContext, EMPTY_ARGS);
            }
        }
        catch (Throwable throwable) {
            throw new MagicScriptRuntimeException(throwable);
        }
        if (target instanceof List) {
            List list = (List)((Object)target);
            if (inLinq) {
                return list.stream().map(it -> FunctionCallHandle.member_access(runtimeContext, it, name, optional, inLinq)).collect(Collectors.toList());
            }
            if (list.size() > 0) {
                return FunctionCallHandle.member_access(runtimeContext, list.get(0), name, optional, false);
            }
            return null;
        }
        if (optional) {
            return null;
        }
        throw new MagicScriptRuntimeException(String.format("\u5728%s\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027%s\u6216\u8005\u65b9\u6cd5get%s\u3001\u65b9\u6cd5is%s,\u5185\u90e8\u7c7b%s", target, name, methodName, methodName, name));
    }

    public static Object call_async(MagicScriptLambdaFunction function, Variables variables, Object ... args) {
        return AsyncCall.execute(function, variables, args);
    }

    public static Object invoke_new_instance(RuntimeContext runtimeContext, Object target, Object[] args) throws Throwable {
        return ClassExtension.newInstance(target, runtimeContext, args);
    }

    public static Object newArrayList(boolean hasSpread, Object[] args) {
        if (!hasSpread) {
            return new ArrayList<Object>(Arrays.asList(args));
        }
        ArrayList<Object> list = new ArrayList<Object>(args.length);
        for (Object item : args) {
            if (item instanceof SpreadValue) {
                Object res = ((SpreadValue)item).getValue();
                if (res == null) continue;
                if (res instanceof Collection) {
                    list.addAll((Collection)res);
                    continue;
                }
                if (res instanceof Map) {
                    throw new MagicScriptRuntimeException("\u4e0d\u80fd\u5728list\u4e2d\u5c55\u5f00map");
                }
                throw new MagicScriptRuntimeException("\u4e0d\u80fd\u5c55\u5f00\u7684\u7c7b\u578b:" + res.getClass());
            }
            list.add(item);
        }
        return list;
    }

    public static Iterator<?> newValueIterator(Object target) {
        if (target instanceof Iterable) {
            return ((Iterable)target).iterator();
        }
        if (target instanceof Iterator) {
            return (Iterator)target;
        }
        if (target instanceof Map) {
            return ((Map)target).values().iterator();
        }
        if (target.getClass().isArray()) {
            return new ArrayValueIterator(target);
        }
        throw new MagicScriptRuntimeException("\u4e0d\u652f\u6301\u5faa\u73af" + target.getClass());
    }

    public static Iterator<?> newKeyValueIterator(Object target) {
        if (target instanceof Iterable) {
            return new KeyValueIterator(((Iterable)target).iterator());
        }
        if (target instanceof Iterator) {
            return new KeyValueIterator((Iterator)target);
        }
        if (target instanceof Map) {
            return new MapKeyValueIterator((Map)target);
        }
        if (target.getClass().isArray()) {
            return new ArrayKeyValueIterator(target);
        }
        throw new MagicScriptRuntimeException("\u4e0d\u652f\u6301\u5faa\u73af" + target.getClass());
    }

    public static Object newLinkedHashMap(Boolean hasSpread, Object[] args) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (args != null) {
            int i = 0;
            int len = args.length;
            while (i < len) {
                Object key = args[i++];
                if (hasSpread.booleanValue() && key instanceof SpreadValue) {
                    Object res = ((SpreadValue)key).getValue();
                    if (res == null) continue;
                    if (res instanceof Map) {
                        map.putAll((Map)res);
                        continue;
                    }
                    if (res instanceof Collection) {
                        int index = 0;
                        for (Object obj : (Collection)res) {
                            map.put(String.valueOf(index++), obj);
                        }
                        continue;
                    }
                    throw new MagicScriptRuntimeException("\u4e0d\u80fd\u5c55\u5f00\u7684\u7c7b\u578b:" + res.getClass());
                }
                map.put(key, args[i++]);
            }
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object set_variable_value(RuntimeContext runtimeContext, Object target, Object name, Object value) throws Throwable {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (name == null) {
            throw new NullPointerException("key is null");
        }
        if (target instanceof Map) {
            ((Map)target).put(name, value);
            return value;
        } else if (target instanceof DynamicAttribute) {
            ((DynamicAttribute)target).setDynamicAttribute(Objects.toString(name, null), value);
            return value;
        } else if (target instanceof Collection) {
            if (!(name instanceof Number)) throw new MagicScriptRuntimeException("\u4e0d\u652f\u6301\u6b64\u8d4b\u503c\u64cd\u4f5c");
            ((List)target).set(((Number)name).intValue(), value);
            return value;
        } else if (target.getClass().isArray()) {
            if (!(name instanceof Number)) throw new MagicScriptRuntimeException("\u4e0d\u652f\u6301\u6b64\u8d4b\u503c\u64cd\u4f5c");
            Array.set(target, ((Number)name).intValue(), value);
            return value;
        } else {
            String text = name.toString();
            Field field = JavaReflection.getField(target, text);
            if (field != null) {
                JavaReflection.setFieldValue(target, field, value);
                return value;
            } else {
                String methodName = text.length() > 1 ? text.substring(0, 1).toUpperCase() + text.substring(1) : text.toUpperCase();
                JavaInvoker<Method> invoker = JavaReflection.getMethod(target, "set" + methodName, value);
                if (invoker == null) {
                    throw new MagicScriptRuntimeException(String.format("\u5728%s\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027%s\u6216\u8005\u65b9\u6cd5set%s", target.getClass(), name, methodName));
                }
                invoker.invoke0(target, runtimeContext, new Object[]{value});
            }
        }
        return value;
    }

    public static Object type_cast(Object object, String target, Object ... args) {
        return ClassConverter.process(object, target, args);
    }

    private static Object[] do_spread(Object[] args) {
        Object[] dest = new Object[args.length];
        int n = args.length;
        int pIndex = 0;
        for (int i = 0; i < n; ++i) {
            Object item = args[i];
            if (item instanceof SpreadValue) {
                Object value = ((SpreadValue)item).getValue();
                Object[] spreadValues = StreamExtension.arrayLikeToList(value).toArray();
                int spreadLength = spreadValues.length;
                if (spreadLength <= 0) continue;
                Object[] valTemp = dest;
                dest = new Object[dest.length + spreadLength - 1];
                System.arraycopy(valTemp, 0, dest, 0, valTemp.length);
                System.arraycopy(spreadValues, 0, dest, pIndex, spreadLength);
                pIndex += spreadLength;
                continue;
            }
            dest[pIndex++] = item;
        }
        return dest;
    }

    static {
        EMPTY_ARGS = new Object[0];
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            FALLBACK = lookup.findStatic(FunctionCallHandle.class, "fallback", MethodType.methodType(Object.class, MethodCallSite.class, Object[].class));
            INVOKE_METHOD = lookup.findStatic(FunctionCallHandle.class, "invoke_method", MethodType.methodType(Object.class, RuntimeContext.class, String.class, Boolean.TYPE, Boolean.TYPE, Object[].class, Object.class));
            INVOKE_FUNCTION = lookup.findStatic(FunctionCallHandle.class, "invoke_function", MethodType.methodType(Object.class, RuntimeContext.class, String.class, Boolean.TYPE, Object[].class, Object.class));
            MEMBER_ACCESS = lookup.findStatic(FunctionCallHandle.class, "member_access", MethodType.methodType(Object.class, RuntimeContext.class, Object.class, String.class, Boolean.TYPE, Boolean.TYPE));
            INVOKE_NEW_INSTANCE = lookup.findStatic(FunctionCallHandle.class, "invoke_new_instance", MethodType.methodType(Object.class, RuntimeContext.class, Object.class, Object[].class));
            SET_VARIABLE_VALUE = lookup.findStatic(FunctionCallHandle.class, "set_variable_value", MethodType.methodType(Object.class, RuntimeContext.class, Object.class, Object.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("FunctionCallHandle\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }
}

