package com.talpa.translate.base.utils;

import android.app.ActivityManager;
import android.view.View;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

import com.photo.translation.R;


/**
 * Create by chenjunsheng on 2020/9/3
 */
public class AntiShakeUtils {

    private final static long INTERNAL_TIME = 500;

    public static boolean isInvalidClick(@NonNull View target) {
        if (ActivityManager.isUserAMonkey()) {
            return isInvalidClick(target, 1000);
        } else {
            return isInvalidClick(target, INTERNAL_TIME);
        }
    }

    public static boolean isInvalidClick(@NonNull View target, @IntRange(from = 0) long internalTime) {
        long curTimeStamp = System.currentTimeMillis();
        long lastClickTimeStamp = 0;
        Object time = target.getTag(R.id.last_click_time_camera);
        if (time == null){
            target.setTag(R.id.last_click_time_camera, curTimeStamp);
            return false;
        }
        lastClickTimeStamp = (Long) time;
        boolean isInvalid = curTimeStamp - lastClickTimeStamp < internalTime;
        if (!isInvalid)
            target.setTag(R.id.last_click_time_camera, curTimeStamp);
        return isInvalid;
    }

}
