/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TargetApi(value=9)
class ReLinker {
    private static final String LIB_DIR = "lib";
    private static final int MAX_TRIES = 5;
    private static final int COPY_BUFFER_SIZE = 8192;

    private ReLinker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    static void loadLibrary(Context context, String library) {
        String libName = System.mapLibraryName(library);
        Class<ReLinker> clazz = ReLinker.class;
        synchronized (ReLinker.class) {
            File workaroundFile = ReLinker.unpackLibrary(context, libName);
            System.load(workaroundFile.getAbsolutePath());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File unpackLibrary(Context context, final String libName) {
        File outputFile = new File(context.getDir(LIB_DIR, 0), libName + "1.1.17");
        if (outputFile.isFile()) {
            return outputFile;
        }
        File cachedLibraryFile = new File(context.getCacheDir(), libName + "1.1.17");
        if (cachedLibraryFile.isFile()) {
            return cachedLibraryFile;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(libName);
            }
        };
        ReLinker.clearOldLibraryFiles(outputFile, filter);
        ReLinker.clearOldLibraryFiles(cachedLibraryFile, filter);
        ApplicationInfo appInfo = context.getApplicationInfo();
        File apkFile = new File(appInfo.sourceDir);
        ZipFile zipFile = null;
        try {
            zipFile = ReLinker.openZipFile(apkFile);
            int tries = 0;
            while (tries++ < 5) {
                ZipEntry libraryEntry = ReLinker.findLibraryEntry(libName, zipFile);
                if (libraryEntry == null) {
                    throw new IllegalStateException("Library " + libName + " for supported ABIs not found in APK file");
                }
                InputStream inputStream = null;
                FileOutputStream fileOut = null;
                try {
                    inputStream = zipFile.getInputStream(libraryEntry);
                    fileOut = new FileOutputStream(outputFile);
                    ReLinker.copy(inputStream, fileOut);
                }
                catch (IOException e) {
                    block16: {
                        try {
                            if (tries <= 2) break block16;
                            outputFile = cachedLibraryFile;
                        }
                        catch (Throwable throwable) {
                            ReLinker.closeSilently(inputStream);
                            ReLinker.closeSilently(fileOut);
                            throw throwable;
                        }
                    }
                    ReLinker.closeSilently(inputStream);
                    ReLinker.closeSilently(fileOut);
                    continue;
                }
                ReLinker.closeSilently(inputStream);
                ReLinker.closeSilently(fileOut);
                ReLinker.setFilePermissions(outputFile);
                break;
            }
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return outputFile;
    }

    @TargetApi(value=21)
    private static ZipEntry findLibraryEntry(String libName, ZipFile zipFile) {
        if (Build.VERSION.SDK_INT >= 21) {
            for (String abi : Build.SUPPORTED_ABIS) {
                ZipEntry libraryEntry = ReLinker.getEntry(libName, zipFile, abi);
                if (libraryEntry == null) continue;
                return libraryEntry;
            }
        }
        return ReLinker.getEntry(libName, zipFile, Build.CPU_ABI);
    }

    private static ZipEntry getEntry(String libName, ZipFile zipFile, String abi) {
        return zipFile.getEntry("lib/" + abi + "/" + libName);
    }

    private static ZipFile openZipFile(File apkFile) {
        int tries = 0;
        ZipFile zipFile = null;
        while (tries++ < 5) {
            try {
                zipFile = new ZipFile(apkFile, 1);
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (zipFile == null) {
            throw new IllegalStateException("Could not open APK file: " + apkFile.getAbsolutePath());
        }
        return zipFile;
    }

    private static void clearOldLibraryFiles(File outputFile, FilenameFilter filter) {
        File[] fileList = outputFile.getParentFile().listFiles(filter);
        if (fileList != null) {
            for (File file : fileList) {
                file.delete();
            }
        }
    }

    @SuppressLint(value={"SetWorldReadable"})
    private static void setFilePermissions(File outputFile) {
        outputFile.setReadable(true, false);
        outputFile.setExecutable(true, false);
        outputFile.setWritable(true);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buf = new byte[8192];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
    }

    private static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

