/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.widget.MediaController;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifError;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifRenderingExecutor;

public class GifDrawable
extends Drawable
implements Animatable,
MediaController.MediaPlayerControl {
    private final ScheduledThreadPoolExecutor mExecutor;
    private volatile boolean mIsRunning = true;
    private final long mInputSourceLength;
    private final Rect mDstRect = new Rect();
    private final Rect mSrcRect;
    protected final Paint mPaint = new Paint(6);
    private final Bitmap mBuffer;
    private final GifInfoHandle mNativeInfoHandle;
    private final ConcurrentLinkedQueue<AnimationListener> mListeners = new ConcurrentLinkedQueue();
    private ColorStateList mTint;
    private PorterDuffColorFilter mTintFilter;
    private PorterDuff.Mode mTintMode;
    private final Runnable mInvalidateTask = new Runnable(){

        @Override
        public void run() {
            GifDrawable.this.invalidateSelf();
        }
    };
    private final Runnable mRenderTask = new SafeRunnable(){

        @Override
        public void doWork() {
            long renderResult = GifDrawable.this.mNativeInfoHandle.renderFrame(GifDrawable.this.mBuffer);
            int invalidationDelay = (int)(renderResult >> 1);
            if ((int)(renderResult & 1L) == 1 && !GifDrawable.this.mListeners.isEmpty()) {
                GifDrawable.this.scheduleSelf(GifDrawable.this.mNotifyListenersTask, 0L);
            }
            if (invalidationDelay >= 0) {
                if (GifDrawable.this.isVisible() && GifDrawable.this.mIsRunning) {
                    GifDrawable.this.mExecutor.schedule(this, (long)invalidationDelay, TimeUnit.MILLISECONDS);
                }
                GifDrawable.this.unscheduleSelf(GifDrawable.this.mInvalidateTask);
                GifDrawable.this.scheduleSelf(GifDrawable.this.mInvalidateTask, 0L);
            }
        }
    };
    private final Runnable mNotifyListenersTask = new Runnable(){

        @Override
        public void run() {
            for (AnimationListener listener : GifDrawable.this.mListeners) {
                listener.onAnimationCompleted();
            }
        }
    };

    public GifDrawable(Resources res, int id) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id));
    }

    public GifDrawable(AssetManager assets, String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifDrawable(String filePath) throws IOException {
        this(GifInfoHandle.openFile(filePath, false), new File(filePath).length(), null, null);
    }

    public GifDrawable(File file) throws IOException {
        this(GifInfoHandle.openFile(file.getPath(), false), file.length(), null, null);
    }

    public GifDrawable(InputStream stream) throws IOException {
        this(GifInfoHandle.openMarkableInputStream(stream, false), -1L, null, null);
    }

    public GifDrawable(AssetFileDescriptor afd) throws IOException {
        this(GifInfoHandle.openAssetFileDescriptor(afd, false), afd.getLength(), null, null);
    }

    public GifDrawable(FileDescriptor fd) throws IOException {
        this(GifInfoHandle.openFd(fd, 0L, false), -1L, null, null);
    }

    public GifDrawable(byte[] bytes) throws IOException {
        this(GifInfoHandle.openByteArray(bytes, false), bytes.length, null, null);
    }

    public GifDrawable(ByteBuffer buffer) throws IOException {
        this(GifInfoHandle.openDirectByteBuffer(buffer, false), buffer.capacity(), null, null);
    }

    public GifDrawable(ContentResolver resolver, Uri uri) throws IOException {
        this(resolver.openAssetFileDescriptor(uri, "r"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    GifDrawable(GifInfoHandle gifInfoHandle, long inputSourceLength, GifDrawable oldDrawable, ScheduledThreadPoolExecutor executor) {
        this.mExecutor = executor != null ? executor : GifRenderingExecutor.getInstance();
        this.mNativeInfoHandle = gifInfoHandle;
        this.mInputSourceLength = inputSourceLength;
        Bitmap oldBitmap = null;
        if (Build.VERSION.SDK_INT >= 19 && oldDrawable != null) {
            GifInfoHandle gifInfoHandle2 = oldDrawable.mNativeInfoHandle;
            synchronized (gifInfoHandle2) {
                if (!oldDrawable.mNativeInfoHandle.isRecycled()) {
                    int oldHeight = oldDrawable.mBuffer.getHeight();
                    int oldWidth = oldDrawable.mBuffer.getWidth();
                    if (oldHeight >= this.mNativeInfoHandle.height && oldWidth >= this.mNativeInfoHandle.width) {
                        oldDrawable.shutdown();
                        oldBitmap = oldDrawable.mBuffer;
                        oldBitmap.eraseColor(0);
                        oldBitmap.reconfigure(this.mNativeInfoHandle.width, this.mNativeInfoHandle.height, Bitmap.Config.ARGB_8888);
                    }
                }
            }
        }
        this.mBuffer = oldBitmap == null ? Bitmap.createBitmap((int)this.mNativeInfoHandle.width, (int)this.mNativeInfoHandle.height, (Bitmap.Config)Bitmap.Config.ARGB_8888) : oldBitmap;
        this.mSrcRect = new Rect(0, 0, this.mNativeInfoHandle.width, this.mNativeInfoHandle.height);
        this.mExecutor.execute(this.mRenderTask);
    }

    public void recycle() {
        this.shutdown();
        this.mBuffer.recycle();
    }

    private void shutdown() {
        this.mIsRunning = false;
        this.unscheduleSelf(this.mInvalidateTask);
        this.mNativeInfoHandle.recycle();
    }

    public boolean isRecycled() {
        return this.mNativeInfoHandle.isRecycled();
    }

    public int getIntrinsicHeight() {
        return this.mNativeInfoHandle.height;
    }

    public int getIntrinsicWidth() {
        return this.mNativeInfoHandle.width;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    public void start() {
        this.mIsRunning = true;
        this.mExecutor.execute(new SafeRunnable(){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.restoreRemainder();
                GifDrawable.this.mRenderTask.run();
            }
        });
    }

    public void reset() {
        this.mExecutor.execute(new SafeRunnable(){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.reset();
            }
        });
    }

    public void stop() {
        this.mIsRunning = false;
        this.unscheduleSelf(this.mInvalidateTask);
        this.mExecutor.execute(new SafeRunnable(){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.saveRemainder();
            }
        });
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public String getComment() {
        return this.mNativeInfoHandle.getComment();
    }

    public int getLoopCount() {
        return this.mNativeInfoHandle.getLoopCount();
    }

    public String toString() {
        return String.format(Locale.US, "GIF: size: %dx%d, frames: %d, error: %d", this.mNativeInfoHandle.width, this.mNativeInfoHandle.height, this.mNativeInfoHandle.imageCount, this.mNativeInfoHandle.getNativeErrorCode());
    }

    public int getNumberOfFrames() {
        return this.mNativeInfoHandle.imageCount;
    }

    public GifError getError() {
        return GifError.fromCode(this.mNativeInfoHandle.getNativeErrorCode());
    }

    public static GifDrawable createFromResource(Resources res, int resourceId) {
        try {
            return new GifDrawable(res, resourceId);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public void setSpeed(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Speed factor is not positive");
        }
        this.mNativeInfoHandle.setSpeedFactor(factor);
    }

    public void pause() {
        this.stop();
    }

    public int getDuration() {
        return this.mNativeInfoHandle.getDuration();
    }

    public int getCurrentPosition() {
        return this.mNativeInfoHandle.getCurrentPosition();
    }

    public void seekTo(final int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Position is not positive");
        }
        this.mExecutor.execute(new SafeRunnable(){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.seekToTime(position, GifDrawable.this.mBuffer);
                GifDrawable.this.scheduleSelf(GifDrawable.this.mInvalidateTask, 0L);
            }
        });
    }

    public void seekToFrame(final int frameIndex) {
        if (frameIndex < 0) {
            throw new IllegalArgumentException("frameIndex is not positive");
        }
        this.mExecutor.execute(new SafeRunnable(){

            @Override
            public void doWork() {
                GifDrawable.this.mNativeInfoHandle.seekToFrame(frameIndex, GifDrawable.this.mBuffer);
                GifDrawable.this.scheduleSelf(GifDrawable.this.mInvalidateTask, 0L);
            }
        });
    }

    public boolean isPlaying() {
        return this.mIsRunning;
    }

    public int getBufferPercentage() {
        return 100;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return false;
    }

    public boolean canSeekForward() {
        return this.getNumberOfFrames() > 1;
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int getFrameByteCount() {
        return this.mBuffer.getRowBytes() * this.mBuffer.getHeight();
    }

    @TargetApi(value=19)
    public long getAllocationByteCount() {
        long byteCount = this.mNativeInfoHandle.getAllocationByteCount();
        byteCount = Build.VERSION.SDK_INT >= 19 ? (byteCount += (long)this.mBuffer.getAllocationByteCount()) : (byteCount += (long)(this.mBuffer.getRowBytes() * this.mBuffer.getHeight()));
        return byteCount;
    }

    public long getInputSourceByteCount() {
        return this.mInputSourceLength;
    }

    public void getPixels(int[] pixels) {
        this.mBuffer.getPixels(pixels, 0, this.mNativeInfoHandle.width, 0, 0, this.mNativeInfoHandle.width, this.mNativeInfoHandle.height);
    }

    public int getPixel(int x, int y) {
        return this.mBuffer.getPixel(x, y);
    }

    protected void onBoundsChange(Rect bounds) {
        this.mDstRect.set(this.getBounds());
    }

    public void draw(Canvas canvas) {
        boolean clearColorFilter;
        if (this.mTintFilter != null && this.mPaint.getColorFilter() == null) {
            this.mPaint.setColorFilter((ColorFilter)this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        if (this.mPaint.getShader() == null) {
            canvas.drawBitmap(this.mBuffer, this.mSrcRect, this.mDstRect, this.mPaint);
        } else {
            canvas.drawRect(this.mDstRect, this.mPaint);
        }
        if (clearColorFilter) {
            this.mPaint.setColorFilter(null);
        }
    }

    public final Paint getPaint() {
        return this.mPaint;
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public void setFilterBitmap(boolean filter) {
        this.mPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public int getMinimumHeight() {
        return this.mNativeInfoHandle.height;
    }

    public int getMinimumWidth() {
        return this.mNativeInfoHandle.width;
    }

    public void addAnimationListener(AnimationListener listener) {
        this.mListeners.add(listener);
    }

    public boolean removeAnimationListener(AnimationListener listener) {
        return this.mListeners.remove(listener);
    }

    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    public Bitmap getCurrentFrame() {
        return this.mBuffer.copy(this.mBuffer.getConfig(), this.mBuffer.isMutable());
    }

    private PorterDuffColorFilter updateTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }

    public void setTintList(ColorStateList tint) {
        this.mTint = tint;
        this.mTintFilter = this.updateTintFilter(tint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTint, tintMode);
        this.invalidateSelf();
    }

    protected boolean onStateChange(int[] stateSet) {
        if (this.mTint != null && this.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTint, this.mTintMode);
            return true;
        }
        return false;
    }

    public boolean isStateful() {
        return super.isStateful() || this.mTint != null && this.mTint.isStateful();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (restart) {
                this.reset();
            }
            if (changed) {
                this.start();
            }
        } else if (changed) {
            this.stop();
        }
        return changed;
    }

    private abstract class SafeRunnable
    implements Runnable {
        private SafeRunnable() {
        }

        @Override
        public final void run() {
            try {
                if (!GifDrawable.this.isRecycled()) {
                    this.doWork();
                }
            }
            catch (Throwable throwable) {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                if (uncaughtExceptionHandler != null) {
                    uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                }
                throw throwable;
            }
        }

        protected abstract void doWork();
    }
}

