/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.os.SystemClock;
import java.util.concurrent.TimeUnit;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.SafeRunnable;

class RenderTask
extends SafeRunnable {
    private final Runnable mNotifyListenersTask = new Runnable(){

        @Override
        public void run() {
            for (AnimationListener listener : RenderTask.this.mGifDrawable.mListeners) {
                listener.onAnimationCompleted();
            }
        }
    };

    RenderTask(GifDrawable gifDrawable) {
        super(gifDrawable);
    }

    @Override
    public void doWork() {
        long invalidationDelay = this.mGifDrawable.mNativeInfoHandle.renderFrame(this.mGifDrawable.mBuffer);
        if (invalidationDelay >= 0L) {
            this.mGifDrawable.mNextFrameRenderTime = SystemClock.elapsedRealtime() + invalidationDelay;
            if (this.mGifDrawable.isVisible() && this.mGifDrawable.mIsRunning && !this.mGifDrawable.mIsRenderingTriggeredOnDraw) {
                this.mGifDrawable.mExecutor.schedule(this, invalidationDelay, TimeUnit.MILLISECONDS);
            }
        } else {
            this.mGifDrawable.mNextFrameRenderTime = Long.MIN_VALUE;
            this.mGifDrawable.mIsRunning = false;
            if (!this.mGifDrawable.mListeners.isEmpty()) {
                this.mGifDrawable.scheduleSelf(this.mNotifyListenersTask, 0L);
            }
        }
        if (this.mGifDrawable.isVisible() && !this.mGifDrawable.mInvalidationHandler.hasMessages(0)) {
            this.mGifDrawable.mInvalidationHandler.sendEmptyMessageAtTime(0, 0L);
        }
    }
}

