/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.Surface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import pl.droidsonroids.gif.GifIOException;

final class GifInfoHandle {
    private volatile long gifInfoPtr;
    final int width;
    final int height;
    final int frameCount;
    static final GifInfoHandle NULL_INFO = new GifInfoHandle(0L, 0, 0, 0);

    private GifInfoHandle(long gifInfoPtr, int width, int height, int frameCount) {
        this.gifInfoPtr = gifInfoPtr;
        this.width = width;
        this.height = height;
        this.frameCount = frameCount;
    }

    static native GifInfoHandle openFd(FileDescriptor var0, long var1, boolean var3) throws GifIOException;

    static native GifInfoHandle openByteArray(byte[] var0, boolean var1) throws GifIOException;

    static native GifInfoHandle openDirectByteBuffer(ByteBuffer var0, boolean var1) throws GifIOException;

    static native GifInfoHandle openStream(InputStream var0, boolean var1) throws GifIOException;

    static native GifInfoHandle openFile(String var0, boolean var1) throws GifIOException;

    private static native long renderFrame(long var0, Bitmap var2);

    private static native void bindSurface(long var0, Surface var2, long[] var3, boolean var4);

    private static native void free(long var0);

    private static native boolean reset(long var0);

    private static native void setSpeedFactor(long var0, float var2);

    private static native String getComment(long var0);

    private static native int getLoopCount(long var0);

    private static native void setLoopCount(long var0, int var2);

    private static native long getSourceLength(long var0);

    private static native int getDuration(long var0);

    private static native int getCurrentPosition(long var0);

    private static native void seekToTime(long var0, int var2, Bitmap var3);

    private static native void seekToFrame(long var0, int var2, Bitmap var3);

    private static native void saveRemainder(long var0);

    private static native long restoreRemainder(long var0);

    private static native long getAllocationByteCount(long var0);

    private static native int getNativeErrorCode(long var0);

    private static native int getCurrentFrameIndex(long var0);

    private static native int getCurrentLoop(long var0);

    private static native void postUnbindSurface(long var0);

    private static native boolean isAnimationCompleted(long var0);

    private static native long[] getSavedState(long var0);

    private static native int restoreSavedState(long var0, long[] var2, Bitmap var3);

    private static native int getFrameDuration(long var0, int var2);

    static GifInfoHandle openMarkableInputStream(InputStream stream, boolean justDecodeMetaData) throws GifIOException {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("InputStream does not support marking");
        }
        return GifInfoHandle.openStream(stream, justDecodeMetaData);
    }

    static GifInfoHandle openAssetFileDescriptor(AssetFileDescriptor afd, boolean justDecodeMetaData) throws IOException {
        try {
            GifInfoHandle gifInfoHandle = GifInfoHandle.openFd(afd.getFileDescriptor(), afd.getStartOffset(), justDecodeMetaData);
            return gifInfoHandle;
        }
        finally {
            afd.close();
        }
    }

    static GifInfoHandle openUri(ContentResolver resolver, Uri uri, boolean justDecodeMetaData) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return GifInfoHandle.openFile(uri.getPath(), justDecodeMetaData);
        }
        return GifInfoHandle.openAssetFileDescriptor(resolver.openAssetFileDescriptor(uri, "r"), justDecodeMetaData);
    }

    synchronized long renderFrame(Bitmap frameBuffer) {
        return GifInfoHandle.renderFrame(this.gifInfoPtr, frameBuffer);
    }

    void bindSurface(Surface surface, long[] savedState, boolean isOpaque) {
        GifInfoHandle.bindSurface(this.gifInfoPtr, surface, savedState, isOpaque);
    }

    synchronized void recycle() {
        GifInfoHandle.free(this.gifInfoPtr);
        this.gifInfoPtr = 0L;
    }

    synchronized long restoreRemainder() {
        return GifInfoHandle.restoreRemainder(this.gifInfoPtr);
    }

    synchronized boolean reset() {
        return GifInfoHandle.reset(this.gifInfoPtr);
    }

    synchronized void saveRemainder() {
        GifInfoHandle.saveRemainder(this.gifInfoPtr);
    }

    synchronized String getComment() {
        return GifInfoHandle.getComment(this.gifInfoPtr);
    }

    synchronized int getLoopCount() {
        return GifInfoHandle.getLoopCount(this.gifInfoPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLoopCount(int loopCount) {
        if (loopCount < 0 || loopCount > 65535) {
            throw new IllegalArgumentException("Loop count of range <0, 65535>");
        }
        GifInfoHandle gifInfoHandle = this;
        synchronized (gifInfoHandle) {
            GifInfoHandle.setLoopCount(this.gifInfoPtr, loopCount);
        }
    }

    synchronized long getSourceLength() {
        return GifInfoHandle.getSourceLength(this.gifInfoPtr);
    }

    synchronized int getNativeErrorCode() {
        return GifInfoHandle.getNativeErrorCode(this.gifInfoPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSpeedFactor(float factor) {
        if (factor <= 0.0f || Float.isNaN(factor)) {
            throw new IllegalArgumentException("Speed factor is not positive");
        }
        if (factor < 0.0f) {
            factor = 0.0f;
        }
        GifInfoHandle gifInfoHandle = this;
        synchronized (gifInfoHandle) {
            GifInfoHandle.setSpeedFactor(this.gifInfoPtr, factor);
        }
    }

    synchronized int getDuration() {
        return GifInfoHandle.getDuration(this.gifInfoPtr);
    }

    synchronized int getCurrentPosition() {
        return GifInfoHandle.getCurrentPosition(this.gifInfoPtr);
    }

    synchronized int getCurrentFrameIndex() {
        return GifInfoHandle.getCurrentFrameIndex(this.gifInfoPtr);
    }

    synchronized int getCurrentLoop() {
        return GifInfoHandle.getCurrentLoop(this.gifInfoPtr);
    }

    synchronized void seekToTime(int position, Bitmap buffer) {
        GifInfoHandle.seekToTime(this.gifInfoPtr, position, buffer);
    }

    synchronized void seekToFrame(int frameIndex, Bitmap buffer) {
        GifInfoHandle.seekToFrame(this.gifInfoPtr, frameIndex, buffer);
    }

    synchronized long getAllocationByteCount() {
        return GifInfoHandle.getAllocationByteCount(this.gifInfoPtr);
    }

    synchronized boolean isRecycled() {
        return this.gifInfoPtr == 0L;
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
        }
        finally {
            super.finalize();
        }
    }

    synchronized void postUnbindSurface() {
        GifInfoHandle.postUnbindSurface(this.gifInfoPtr);
    }

    synchronized boolean isAnimationCompleted() {
        return GifInfoHandle.isAnimationCompleted(this.gifInfoPtr);
    }

    synchronized long[] getSavedState() {
        return GifInfoHandle.getSavedState(this.gifInfoPtr);
    }

    synchronized int restoreSavedState(long[] savedState, Bitmap mBuffer) {
        return GifInfoHandle.restoreSavedState(this.gifInfoPtr, savedState, mBuffer);
    }

    synchronized int getFrameDuration(int index) {
        if (index < 0 || index >= this.frameCount) {
            throw new IndexOutOfBoundsException("Frame index is out of bounds");
        }
        return GifInfoHandle.getFrameDuration(this.gifInfoPtr, index);
    }

    static {
        System.loadLibrary("pl_droidsonroids_gif");
    }
}

