/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import java.io.IOException;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;

public class GifTextView
extends TextView {
    private GifViewUtils.GifViewAttributes viewAttributes;

    public GifTextView(Context context) {
        super(context);
    }

    public GifTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public GifTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle, 0);
    }

    @RequiresApi(value=21)
    public GifTextView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.init(attrs, defStyle, defStyleRes);
    }

    private static void setDrawablesVisible(Drawable[] drawables, boolean visible) {
        for (Drawable drawable : drawables) {
            if (drawable == null) continue;
            drawable.setVisible(visible, false);
        }
    }

    private void init(AttributeSet attrs, int defStyle, int defStyleRes) {
        if (attrs != null) {
            Drawable left = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableLeft", 0));
            Drawable top = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableTop", 0));
            Drawable right = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableRight", 0));
            Drawable bottom = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableBottom", 0));
            Drawable start = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableStart", 0));
            Drawable end = this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableEnd", 0));
            if (this.getLayoutDirection() == 0) {
                if (start == null) {
                    start = left;
                }
                if (end == null) {
                    end = right;
                }
            } else {
                if (start == null) {
                    start = right;
                }
                if (end == null) {
                    end = left;
                }
            }
            this.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
            this.setBackground(this.getGifOrDefaultDrawable(attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "background", 0)));
            this.viewAttributes = new GifViewUtils.GifViewAttributes((View)this, attrs, defStyle, defStyleRes);
            this.applyGifViewAttributes();
        }
        this.viewAttributes = new GifViewUtils.GifViewAttributes();
    }

    private void applyGifViewAttributes() {
        if (this.viewAttributes.mLoopCount < 0) {
            return;
        }
        for (Drawable drawable : this.getCompoundDrawables()) {
            GifViewUtils.applyLoopCount(this.viewAttributes.mLoopCount, drawable);
        }
        for (Drawable drawable : this.getCompoundDrawablesRelative()) {
            GifViewUtils.applyLoopCount(this.viewAttributes.mLoopCount, drawable);
        }
        GifViewUtils.applyLoopCount(this.viewAttributes.mLoopCount, this.getBackground());
    }

    private Drawable getGifOrDefaultDrawable(int resId) {
        if (resId == 0) {
            return null;
        }
        Resources resources = this.getResources();
        String resourceTypeName = resources.getResourceTypeName(resId);
        if (!this.isInEditMode() && GifViewUtils.SUPPORTED_RESOURCE_TYPE_NAMES.contains(resourceTypeName)) {
            try {
                return new GifDrawable(resources, resId);
            }
            catch (Resources.NotFoundException | IOException throwable) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return resources.getDrawable(resId, this.getContext().getTheme());
        }
        return resources.getDrawable(resId);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        this.setCompoundDrawablesWithIntrinsicBounds(this.getGifOrDefaultDrawable(left), this.getGifOrDefaultDrawable(top), this.getGifOrDefaultDrawable(right), this.getGifOrDefaultDrawable(bottom));
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(this.getGifOrDefaultDrawable(start), this.getGifOrDefaultDrawable(top), this.getGifOrDefaultDrawable(end), this.getGifOrDefaultDrawable(bottom));
    }

    public Parcelable onSaveInstanceState() {
        Drawable[] savedDrawables = new Drawable[7];
        if (this.viewAttributes.freezesAnimation) {
            Drawable[] compoundDrawables = this.getCompoundDrawables();
            System.arraycopy(compoundDrawables, 0, savedDrawables, 0, compoundDrawables.length);
            Drawable[] compoundDrawablesRelative = this.getCompoundDrawablesRelative();
            savedDrawables[4] = compoundDrawablesRelative[0];
            savedDrawables[5] = compoundDrawablesRelative[2];
            savedDrawables[6] = this.getBackground();
        }
        return new GifViewSavedState(super.onSaveInstanceState(), savedDrawables);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof GifViewSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        GifViewSavedState ss = (GifViewSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        ss.restoreState(compoundDrawables[0], 0);
        ss.restoreState(compoundDrawables[1], 1);
        ss.restoreState(compoundDrawables[2], 2);
        ss.restoreState(compoundDrawables[3], 3);
        Drawable[] compoundDrawablesRelative = this.getCompoundDrawablesRelative();
        ss.restoreState(compoundDrawablesRelative[0], 4);
        ss.restoreState(compoundDrawablesRelative[2], 5);
        ss.restoreState(this.getBackground(), 6);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setCompoundDrawablesVisible(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setCompoundDrawablesVisible(false);
    }

    public void setBackgroundResource(int resId) {
        this.setBackground(this.getGifOrDefaultDrawable(resId));
    }

    private void setCompoundDrawablesVisible(boolean visible) {
        GifTextView.setDrawablesVisible(this.getCompoundDrawables(), visible);
        GifTextView.setDrawablesVisible(this.getCompoundDrawablesRelative(), visible);
    }

    public void setFreezesAnimation(boolean freezesAnimation) {
        this.viewAttributes.freezesAnimation = freezesAnimation;
    }
}

