/*
 * Decompiled with CFR 0.152.
 */
package com.adfly.mediation.max;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.adfly.sdk.ads.AdType;
import com.adfly.sdk.ads.AdView;
import com.adfly.sdk.core.AdError;
import com.adfly.sdk.core.AdFlySdk;
import com.adfly.sdk.core.AdListener;
import com.adfly.sdk.core.AdflyAd;
import com.adfly.sdk.core.SdkConfiguration;
import com.adfly.sdk.core.SdkInitializationListener;
import com.adfly.sdk.interstitial.InterstitialAd;
import com.adfly.sdk.interstitial.InterstitialAdListener;
import com.adfly.sdk.nativead.MediaView;
import com.adfly.sdk.nativead.NativeAd;
import com.adfly.sdk.nativead.NativeAdListener;
import com.adfly.sdk.nativead.NativeAdView;
import com.adfly.sdk.rewardedvideo.RewardedVideoAd;
import com.adfly.sdk.rewardedvideo.RewardedVideoListener;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;

public class AdFlyMediationAdapter
extends MediationAdapterBase
implements MaxRewardedAdapter,
MaxInterstitialAdapter,
MaxAdViewAdapter {
    private NativeAd mNativeAd;
    private NativeAdView mNativeAdView;
    private RewardedVideoAd mRewardedVideoAd;
    private InterstitialAd mInterstitialAd;
    private AdView mAdView;

    public AdFlyMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters initializationParameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        Bundle serverParams = initializationParameters.getServerParameters();
        Map localParams = initializationParameters.getLocalExtraParameters();
        Bundle params = initializationParameters.getCustomParameters();
        String key = params.getString("key");
        String secret = params.getString("secret");
        Log.d((String)"MaxAdapter", (String)("initialize, params: " + params + "\nserverParams: " + serverParams + "\nlocalParams: " + localParams));
        if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)secret)) {
            SdkConfiguration configuration = new SdkConfiguration.Builder().appKey(key).appSecret(secret).build();
            AdFlySdk.initialize((Application)activity.getApplication(), (SdkConfiguration)configuration, (SdkInitializationListener)new SdkInitializationListener(){

                public void onInitializationFinished() {
                    Log.d((String)"AdFlyMaxAdapter", (String)"onInitializationFinished");
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
                }
            });
        } else {
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, "invalid key and secret");
        }
    }

    public String getSdkVersion() {
        return AdFlySdk.getVersion();
    }

    public String getAdapterVersion() {
        return "0.20.0.0";
    }

    public void onDestroy() {
        if (this.mNativeAd != null) {
            this.mNativeAd.destroy();
            this.mNativeAd = null;
        }
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy();
            this.mRewardedVideoAd = null;
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
            this.mInterstitialAd = null;
        }
        if (this.mAdView != null) {
            this.mAdView.destroy();
            this.mAdView = null;
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        String unitId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        Log.d((String)"AdFlyMaxAdapter", (String)("loadRewardedAd: " + unitId));
        this.mRewardedVideoAd = RewardedVideoAd.getInstance((String)unitId);
        this.mRewardedVideoAd.setRewardedVideoListener((RewardedVideoListener)new RewardedAdListener(maxRewardedAdapterListener));
        this.mRewardedVideoAd.loadAd();
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        String unitId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        Bundle params = maxAdapterResponseParameters.getCustomParameters();
        String entry = params.getString("entry", null);
        Log.d((String)"AdFlyMaxAdapter", (String)("showRewardedAd: " + unitId));
        if (this.mRewardedVideoAd == null) {
            maxRewardedAdapterListener.onRewardedAdDisplayFailed(new MaxAdapterError(5003, "not load."));
            return;
        }
        RewardedVideoAd.updateActivity((Activity)activity);
        this.mRewardedVideoAd.setRewardedVideoListener((RewardedVideoListener)new RewardedAdListener(maxRewardedAdapterListener));
        this.mRewardedVideoAd.show(entry);
    }

    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        String unitId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        this.mNativeAd = new NativeAd(unitId);
        this.mNativeAd.setAdListener((NativeAdListener)new MaxNativeAdListener(activity, maxNativeAdAdapterListener));
        this.mNativeAd.loadAd();
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        String unitId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        Log.d((String)"AdFlyMaxAdapter", (String)("loadInterstitialAd: " + unitId));
        this.mInterstitialAd = InterstitialAd.getInstance((String)unitId);
        this.mInterstitialAd.setAdListener((InterstitialAdListener)new InterstitalListener(maxInterstitialAdapterListener));
        this.mInterstitialAd.loadAd();
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        String unitId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        Bundle params = maxAdapterResponseParameters.getCustomParameters();
        String entry = params.getString("entry", null);
        Log.d((String)"AdFlyMaxAdapter", (String)("showInterstitialAd: " + unitId));
        if (this.mInterstitialAd == null) {
            maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(new MaxAdapterError(5003, "not load."));
            return;
        }
        InterstitialAd.updateActivity((Activity)activity);
        this.mInterstitialAd.setAdListener((InterstitialAdListener)new InterstitalListener(maxInterstitialAdapterListener));
        this.mInterstitialAd.show(entry);
    }

    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        String unitId = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
        Log.d((String)"AdFlyMaxAdapter", (String)("loadAdViewAd: " + unitId + ", format; " + maxAdFormat));
        AdType adType = AdFlyMediationAdapter.sizeFromAdFormat(maxAdFormat);
        this.mAdView = new AdView((Context)activity, unitId, adType);
        this.mAdView.setAdListener((AdListener)new AdViewListener(this.mAdView, maxAdViewAdapterListener));
        this.mAdView.setAutoRefresh(false);
        this.mAdView.loadAd();
    }

    private static AdType sizeFromAdFormat(MaxAdFormat adFormat) {
        if (MaxAdFormat.BANNER == adFormat) {
            return AdType.BANNER;
        }
        if (MaxAdFormat.MREC == adFormat) {
            return AdType.MREC;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private class MaxAdFlyNativeAd
    extends MaxNativeAd {
        private MaxAdFlyNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            final NativeAd nativeAd = AdFlyMediationAdapter.this.mNativeAd;
            if (nativeAd == null) {
                Log.e((String)"MaxAdapter", (String)"Failed to register native ad views: native ad is null.");
                return;
            }
            AdFlyMediationAdapter.this.mNativeAdView = new NativeAdView(maxNativeAdView.getContext());
            View mainView = maxNativeAdView.getMainView();
            maxNativeAdView.removeView(mainView);
            AdFlyMediationAdapter.this.mNativeAdView.addView(mainView);
            maxNativeAdView.addView((View)AdFlyMediationAdapter.this.mNativeAdView);
            final ArrayList<Object> clickableViews = new ArrayList<Object>();
            if (AppLovinSdkUtils.isValidString((String)this.getTitle()) && maxNativeAdView.getTitleTextView() != null) {
                clickableViews.add(maxNativeAdView.getTitleTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getAdvertiser()) && maxNativeAdView.getAdvertiserTextView() != null) {
                clickableViews.add(maxNativeAdView.getAdvertiserTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getBody()) && maxNativeAdView.getBodyTextView() != null) {
                clickableViews.add(maxNativeAdView.getBodyTextView());
            }
            if (AppLovinSdkUtils.isValidString((String)this.getCallToAction()) && maxNativeAdView.getCallToActionButton() != null) {
                clickableViews.add(maxNativeAdView.getCallToActionButton());
            }
            if (this.getIcon() != null && maxNativeAdView.getIconImageView() != null) {
                clickableViews.add(maxNativeAdView.getIconImageView());
            }
            if (this.getMediaView() != null && maxNativeAdView.getMediaContentViewGroup() != null) {
                clickableViews.add(maxNativeAdView.getMediaContentViewGroup());
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    nativeAd.showView(AdFlyMediationAdapter.this.mNativeAdView, (MediaView)MaxAdFlyNativeAd.this.getMediaView(), clickableViews);
                }
            });
        }
    }

    private class MaxNativeAdListener
    implements NativeAdListener {
        private final WeakReference<Activity> activityRef;
        private final MaxNativeAdAdapterListener listener;

        public MaxNativeAdListener(Activity activity, MaxNativeAdAdapterListener listener) {
            this.activityRef = new WeakReference<Activity>(activity);
            this.listener = listener;
        }

        public void onMediaDownloaded(AdflyAd ad) {
        }

        public void onError(AdflyAd ad, AdError error) {
            Log.d((String)"AdFlyMaxAdapter", (String)("onError: " + error));
        }

        public void onAdLoaded(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onAdLoaded");
            final Activity activity = (Activity)this.activityRef.get();
            if (activity == null) {
                Log.e((String)"MaxAdapter", (String)"Native ad failed to load: activity reference is null when ad is loaded");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.INVALID_LOAD_STATE);
                return;
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MediaView mediaView = new MediaView((Context)activity);
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(AdFlyMediationAdapter.this.mNativeAd.getTitle()).setAdvertiser(AdFlyMediationAdapter.this.mNativeAd.getTag()).setBody(AdFlyMediationAdapter.this.mNativeAd.getBody()).setCallToAction(AdFlyMediationAdapter.this.mNativeAd.getCallToAction()).setIconView(new View((Context)activity)).setMediaView((View)mediaView);
                    MaxAdFlyNativeAd maxNativeAd = new MaxAdFlyNativeAd(builder);
                    MaxNativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
                }
            });
        }

        public void onAdLoadFailure(AdflyAd ad, AdError adError) {
            Log.d((String)"AdFlyMaxAdapter", (String)("onAdLoadFailure: " + adError));
            this.listener.onNativeAdLoadFailed(new MaxAdapterError(adError.getErrorCode(), adError.getErrorMessage()));
        }

        public void onAdClicked(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onAdClicked");
            this.listener.onNativeAdClicked();
        }

        public void onAdImpression(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onAdImpression");
            this.listener.onNativeAdDisplayed(null);
        }
    }

    private class RewardedAdListener
    implements RewardedVideoListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward = false;

        public RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onRewardedAdLoadSuccess(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onRewardedAdLoadSuccess");
            this.listener.onRewardedAdLoaded();
        }

        public void onRewardedAdLoadFailure(AdflyAd ad, AdError adError) {
            Log.e((String)"AdFlyMaxAdapter", (String)("onRewardedAdLoadFailure: " + adError));
            this.listener.onRewardedAdLoadFailed(new MaxAdapterError(adError.getErrorCode(), adError.getErrorMessage()));
        }

        public void onRewardedAdShowed(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onRewardedAdShowed");
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onRewardedAdShowError(AdflyAd ad, AdError adError) {
            Log.e((String)"AdFlyMaxAdapter", (String)("onRewardedAdShowError: " + adError));
            this.listener.onRewardedAdDisplayFailed(new MaxAdapterError(adError.getErrorCode(), adError.getErrorMessage()));
        }

        public void onRewardedAdCompleted(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onRewardedAdCompleted");
            this.listener.onRewardedAdVideoCompleted();
            this.hasGrantedReward = true;
        }

        public void onRewardedAdClosed(AdflyAd ad) {
            if (this.hasGrantedReward) {
                MaxReward reward = AdFlyMediationAdapter.this.getReward();
                Log.d((String)"AdFlyMaxAdapter", (String)("Rewarded user with reward: " + reward));
                this.listener.onUserRewarded(reward);
            }
            Log.d((String)"AdFlyMaxAdapter", (String)"onRewardedAdClosed");
            this.listener.onRewardedAdHidden();
        }

        public void onRewardedAdClick(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onRewardedAdClick");
            this.listener.onRewardedAdClicked();
        }
    }

    private static class InterstitalListener
    implements InterstitialAdListener {
        private final MaxInterstitialAdapterListener listener;

        public InterstitalListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onAdLoadSuccess(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onInterstitialAdLoaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onAdLoadFailure(AdflyAd ad, AdError adError) {
            Log.e((String)"AdFlyMaxAdapter", (String)("onInterstitialAdLoadFailed: " + adError));
            this.listener.onInterstitialAdLoadFailed(new MaxAdapterError(adError.getErrorCode(), adError.getErrorMessage()));
        }

        public void onAdShowed(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onInterstitialAdDisplayed");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdShowError(AdflyAd ad, AdError adError) {
            Log.e((String)"AdFlyMaxAdapter", (String)("onInterstitialAdDisplayFailed: " + adError));
            this.listener.onInterstitialAdDisplayFailed(new MaxAdapterError(adError.getErrorCode(), adError.getErrorMessage()));
        }

        public void onAdClosed(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onInterstitialAdHidden");
            this.listener.onInterstitialAdHidden();
        }

        public void onAdClick(AdflyAd ad) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onInterstitialAdClicked");
            this.listener.onInterstitialAdClicked();
        }
    }

    private static class AdViewListener
    implements AdListener {
        private final AdView adView;
        private final MaxAdViewAdapterListener listener;

        public AdViewListener(AdView adView, MaxAdViewAdapterListener listener) {
            this.adView = adView;
            this.listener = listener;
        }

        public void onError(AdflyAd adflyAd, AdError adError) {
            Log.d((String)"AdFlyMaxAdapter", (String)("onError: " + adError));
        }

        public void onAdLoaded(AdflyAd adflyAd) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onAdLoaded");
            this.listener.onAdViewAdLoaded((View)this.adView);
        }

        public void onAdLoadFailure(AdflyAd adflyAd, AdError adError) {
            Log.d((String)"AdFlyMaxAdapter", (String)("onAdLoadFailure: " + adError));
            this.listener.onAdViewAdLoadFailed(new MaxAdapterError(adError.getErrorCode(), adError.getErrorMessage()));
        }

        public void onAdClicked(AdflyAd adflyAd) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onAdClicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdImpression(AdflyAd adflyAd) {
            Log.d((String)"AdFlyMaxAdapter", (String)"onAdImpression");
            this.listener.onAdViewAdDisplayed();
        }
    }
}

