/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.stickylistheaders;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DistinctMultiHashMap<TKey, TItemValue> {
    private IDMapper<TKey, TItemValue> mIDMapper;
    LinkedHashMap<Object, List<TItemValue>> mKeyToValuesMap = new LinkedHashMap();
    LinkedHashMap<Object, TKey> mValueToKeyIndexer = new LinkedHashMap();

    DistinctMultiHashMap() {
        this(new IDMapper<TKey, TItemValue>(){

            @Override
            public Object keyToKeyId(TKey key) {
                return key;
            }

            @Override
            public TKey keyIdToKey(Object keyId) {
                return keyId;
            }

            @Override
            public Object valueToValueId(TItemValue value) {
                return value;
            }

            @Override
            public TItemValue valueIdToValue(Object valueId) {
                return valueId;
            }
        });
    }

    DistinctMultiHashMap(IDMapper<TKey, TItemValue> idMapper) {
        this.mIDMapper = idMapper;
    }

    public List<TItemValue> get(TKey key) {
        return this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(key));
    }

    public TKey getKey(TItemValue value) {
        return this.mValueToKeyIndexer.get(this.mIDMapper.valueToValueId(value));
    }

    public void add(TKey key, TItemValue value) {
        TKey keyForValue;
        Object keyId = this.mIDMapper.keyToKeyId(key);
        if (this.mKeyToValuesMap.get(keyId) == null) {
            this.mKeyToValuesMap.put(keyId, new ArrayList());
        }
        if ((keyForValue = this.getKey(value)) != null) {
            this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(keyForValue)).remove(value);
        }
        this.mValueToKeyIndexer.put(this.mIDMapper.valueToValueId(value), key);
        if (!this.containsValue(this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(key)), value)) {
            this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(key)).add(value);
        }
    }

    public void removeKey(TKey key) {
        if (this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(key)) != null) {
            for (TItemValue value : this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(key))) {
                this.mValueToKeyIndexer.remove(this.mIDMapper.valueToValueId(value));
            }
            this.mKeyToValuesMap.remove(this.mIDMapper.keyToKeyId(key));
        }
    }

    public void removeValue(TItemValue value) {
        List<TItemValue> itemValues;
        if (this.getKey(value) != null && (itemValues = this.mKeyToValuesMap.get(this.mIDMapper.keyToKeyId(this.getKey(value)))) != null) {
            itemValues.remove(value);
        }
        this.mValueToKeyIndexer.remove(this.mIDMapper.valueToValueId(value));
    }

    public void clear() {
        this.mValueToKeyIndexer.clear();
        this.mKeyToValuesMap.clear();
    }

    public void clearValues() {
        for (Map.Entry<Object, List<TItemValue>> entry : this.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().clear();
        }
        this.mValueToKeyIndexer.clear();
    }

    public Set<Map.Entry<Object, List<TItemValue>>> entrySet() {
        return this.mKeyToValuesMap.entrySet();
    }

    public Set<Map.Entry<Object, TKey>> reverseEntrySet() {
        return this.mValueToKeyIndexer.entrySet();
    }

    public int size() {
        return this.mKeyToValuesMap.size();
    }

    public int valuesSize() {
        return this.mValueToKeyIndexer.size();
    }

    protected boolean containsValue(List<TItemValue> list, TItemValue value) {
        for (TItemValue itemValue : list) {
            if (!this.mIDMapper.valueToValueId(itemValue).equals(this.mIDMapper.valueToValueId(value))) continue;
            return true;
        }
        return false;
    }

    public TItemValue getValueByPosition(int position) {
        Object[] vauleIdArray = this.mValueToKeyIndexer.keySet().toArray();
        if (position > vauleIdArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object valueId = vauleIdArray[position];
        return this.mIDMapper.valueIdToValue(valueId);
    }

    static interface IDMapper<TKey, TItemValue> {
        public Object keyToKeyId(TKey var1);

        public TKey keyIdToKey(Object var1);

        public Object valueToValueId(TItemValue var1);

        public TItemValue valueIdToValue(Object var1);
    }
}

