/*
 * Decompiled with CFR 0.152.
 */
package se.emilsjolander.stickylistheaders;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import se.emilsjolander.stickylistheaders.DistinctMultiHashMap;
import se.emilsjolander.stickylistheaders.DualHashMap;
import se.emilsjolander.stickylistheaders.StickyListHeadersAdapter;

class ExpandableStickyListHeadersAdapter
extends BaseAdapter
implements StickyListHeadersAdapter {
    private final StickyListHeadersAdapter mInnerAdapter;
    DualHashMap<View, Long> mViewToItemIdMap = new DualHashMap();
    DistinctMultiHashMap<Integer, View> mHeaderIdToViewMap = new DistinctMultiHashMap();
    List<Long> mCollapseHeaderIds = new ArrayList<Long>();

    ExpandableStickyListHeadersAdapter(StickyListHeadersAdapter innerAdapter) {
        this.mInnerAdapter = innerAdapter;
    }

    @Override
    public View getHeaderView(int position, View convertView, ViewGroup parent) {
        return this.mInnerAdapter.getHeaderView(position, convertView, parent);
    }

    @Override
    public long getHeaderId(int position) {
        return this.mInnerAdapter.getHeaderId(position);
    }

    public boolean areAllItemsEnabled() {
        return this.mInnerAdapter.areAllItemsEnabled();
    }

    public boolean isEnabled(int i) {
        return this.mInnerAdapter.isEnabled(i);
    }

    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.mInnerAdapter.registerDataSetObserver(dataSetObserver);
    }

    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.mInnerAdapter.unregisterDataSetObserver(dataSetObserver);
    }

    public int getCount() {
        return this.mInnerAdapter.getCount();
    }

    public Object getItem(int i) {
        return this.mInnerAdapter.getItem(i);
    }

    public long getItemId(int i) {
        return this.mInnerAdapter.getItemId(i);
    }

    public boolean hasStableIds() {
        return this.mInnerAdapter.hasStableIds();
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        View convertView = this.mInnerAdapter.getView(i, view, viewGroup);
        this.mViewToItemIdMap.put(convertView, this.getItemId(i));
        this.mHeaderIdToViewMap.add((int)this.getHeaderId(i), convertView);
        if (this.mCollapseHeaderIds.contains(this.getHeaderId(i))) {
            convertView.setVisibility(8);
        } else {
            convertView.setVisibility(0);
        }
        return convertView;
    }

    public int getItemViewType(int i) {
        return this.mInnerAdapter.getItemViewType(i);
    }

    public int getViewTypeCount() {
        return this.mInnerAdapter.getViewTypeCount();
    }

    public boolean isEmpty() {
        return this.mInnerAdapter.isEmpty();
    }

    public List<View> getItemViewsByHeaderId(long headerId) {
        return this.mHeaderIdToViewMap.get((int)headerId);
    }

    public boolean isHeaderCollapsed(long headerId) {
        return this.mCollapseHeaderIds.contains(headerId);
    }

    public void expand(long headerId) {
        if (this.isHeaderCollapsed(headerId)) {
            this.mCollapseHeaderIds.remove(headerId);
        }
    }

    public void collapse(long headerId) {
        if (!this.isHeaderCollapsed(headerId)) {
            this.mCollapseHeaderIds.add(headerId);
        }
    }

    public View findViewByItemId(long itemId) {
        return this.mViewToItemIdMap.getKey(itemId);
    }

    public long findItemIdByView(View view) {
        return this.mViewToItemIdMap.get(view);
    }
}

