/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.entry;

import top.canyie.pine.Pine;
import top.canyie.pine.utils.Primitives;

public final class X86Entry {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    private X86Entry() {
    }

    private static void voidBridge(int artMethod, int extras, int ebx) throws Throwable {
        X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static int intBridge(int artMethod, int extras, int ebx) throws Throwable {
        return (Integer)X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static long longBridge(int artMethod, int extras, int ebx) throws Throwable {
        return (Long)X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static double doubleBridge(int artMethod, int extras, int ebx) throws Throwable {
        return (Double)X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static float floatBridge(int artMethod, int extras, int ebx) throws Throwable {
        return ((Float)X86Entry.handleBridge(artMethod, extras, ebx)).floatValue();
    }

    private static boolean booleanBridge(int artMethod, int extras, int ebx) throws Throwable {
        return (Boolean)X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static byte byteBridge(int artMethod, int extras, int ebx) throws Throwable {
        return (Byte)X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static char charBridge(int artMethod, int extras, int ebx) throws Throwable {
        return ((Character)X86Entry.handleBridge(artMethod, extras, ebx)).charValue();
    }

    private static short shortBridge(int artMethod, int extras, int ebx) throws Throwable {
        return (Short)X86Entry.handleBridge(artMethod, extras, ebx);
    }

    private static Object objectBridge(int artMethod, int extras, int ebx) throws Throwable {
        return X86Entry.handleBridge(artMethod, extras, ebx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object handleBridge(int artMethod, int extras, int ebx) throws Throwable {
        Object[] args;
        Object receiver;
        Pine.log("handleBridge: artMethod=%#x extras=%#x ebx=%#x", artMethod, extras, ebx);
        Pine.HookRecord hookRecord = Pine.getHookRecord(artMethod);
        int[] argsAsInts = X86Entry.getArgsAsInts(hookRecord, extras, ebx);
        long thread = Pine.currentArtThread0();
        int index = 0;
        if (hookRecord.isStatic) {
            receiver = null;
        } else {
            receiver = Pine.getObject(thread, argsAsInts[0]);
            index = 1;
        }
        if (hookRecord.paramNumber > 0) {
            args = new Object[hookRecord.paramNumber];
            for (int i = 0; i < hookRecord.paramNumber; ++i) {
                Object value;
                Class<?> paramType = hookRecord.paramTypes[i];
                if (paramType.isPrimitive()) {
                    if (paramType == Integer.TYPE) {
                        value = argsAsInts[index];
                    } else if (paramType == Long.TYPE) {
                        value = Primitives.ints2Long(argsAsInts[index++], argsAsInts[index]);
                    } else if (paramType == Double.TYPE) {
                        value = Primitives.ints2Double(argsAsInts[index++], argsAsInts[index]);
                    } else if (paramType == Float.TYPE) {
                        value = Float.valueOf(Float.intBitsToFloat(argsAsInts[index]));
                    } else if (paramType == Boolean.TYPE) {
                        value = argsAsInts[index] != 0;
                    } else if (paramType == Short.TYPE) {
                        value = (short)argsAsInts[index];
                    } else if (paramType == Character.TYPE) {
                        value = Character.valueOf((char)argsAsInts[index]);
                    } else {
                        if (paramType != Byte.TYPE) throw new AssertionError((Object)("Unknown primitive type: " + paramType));
                        value = (byte)argsAsInts[index];
                    }
                } else {
                    value = Pine.getObject(thread, argsAsInts[index]);
                }
                args[i] = value;
                ++index;
            }
            return Pine.handleCall(hookRecord, receiver, args);
        } else {
            args = Pine.EMPTY_OBJECT_ARRAY;
        }
        return Pine.handleCall(hookRecord, receiver, args);
    }

    private static int[] getArgsAsInts(Pine.HookRecord hookRecord, int extras, int ebx) {
        Class<?>[] paramTypes;
        int len = hookRecord.isStatic ? 0 : 1;
        for (Class<?> paramType : paramTypes = hookRecord.paramTypes) {
            len += paramType == Long.TYPE || paramType == Double.TYPE ? 2 : 1;
        }
        int[] array = len != 0 ? new int[len] : EMPTY_INT_ARRAY;
        Pine.getArgsX86(extras, array, ebx);
        return array;
    }
}

