/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.entry;

import top.canyie.pine.Pine;
import top.canyie.pine.PineConfig;
import top.canyie.pine.utils.Primitives;
import top.canyie.pine.utils.ThreeTuple;

public final class Arm32Entry {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final int CR_SIZE = 3;
    private static final int FPR_SIZE = 16;
    private static final boolean USE_HARDFP = PineConfig.sdkLevel >= 23;
    private static final boolean DISALLOW_LONG_CROSS_CR_AND_STACK = PineConfig.sdkLevel >= 31;

    private Arm32Entry() {
    }

    private static void voidBridge(int artMethod, int extras, int sp) throws Throwable {
        Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static int intBridge(int artMethod, int extras, int sp) throws Throwable {
        return (Integer)Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static long longBridge(int artMethod, int extras, int sp) throws Throwable {
        return (Long)Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static double doubleBridge(int artMethod, int extras, int sp) throws Throwable {
        return (Double)Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static float floatBridge(int artMethod, int extras, int sp) throws Throwable {
        return ((Float)Arm32Entry.handleBridge(artMethod, extras, sp)).floatValue();
    }

    private static boolean booleanBridge(int artMethod, int extras, int sp) throws Throwable {
        return (Boolean)Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static byte byteBridge(int artMethod, int extras, int sp) throws Throwable {
        return (Byte)Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static char charBridge(int artMethod, int extras, int sp) throws Throwable {
        return ((Character)Arm32Entry.handleBridge(artMethod, extras, sp)).charValue();
    }

    private static short shortBridge(int artMethod, int extras, int sp) throws Throwable {
        return (Short)Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    private static Object objectBridge(int artMethod, int extras, int sp) throws Throwable {
        return Arm32Entry.handleBridge(artMethod, extras, sp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object handleBridge(int artMethod, int originExtras, int sp) throws Throwable {
        Object[] args;
        Object receiver;
        int extras = (int)Pine.cloneExtras(originExtras);
        Pine.log("handleBridge: artMethod=%#x originExtras=%#x extras=%#x sp=%#x", artMethod, originExtras, extras, sp);
        Pine.HookRecord hookRecord = Pine.getHookRecord(artMethod);
        ThreeTuple<int[], int[], float[]> threeTuple = Arm32Entry.getArgs(hookRecord, extras, sp);
        int[] coreRegisters = (int[])threeTuple.a;
        int[] stack = (int[])threeTuple.b;
        float[] fpRegisters = (float[])threeTuple.c;
        long thread = Pine.currentArtThread0();
        int crIndex = 0;
        int stackIndex = 0;
        int floatIndex = 0;
        int doubleIndex = 0;
        if (hookRecord.isStatic) {
            receiver = null;
        } else {
            receiver = Pine.getObject(thread, coreRegisters[0]);
            crIndex = 1;
            stackIndex = 1;
        }
        if (hookRecord.paramNumber > 0) {
            args = new Object[hookRecord.paramNumber];
            for (int i = 0; i < hookRecord.paramNumber; ++i) {
                Object value;
                Class<?> paramType = hookRecord.paramTypes[i];
                if (paramType == Double.TYPE) {
                    if ((doubleIndex = Math.max(doubleIndex, Primitives.evenUp(floatIndex))) < fpRegisters.length) {
                        float l = fpRegisters[doubleIndex++];
                        float h = fpRegisters[doubleIndex++];
                        value = Primitives.floats2Double(l, h);
                        ++stackIndex;
                    } else {
                        int l = crIndex < coreRegisters.length && !USE_HARDFP ? coreRegisters[crIndex++] : stack[stackIndex];
                        int h = crIndex < coreRegisters.length && !USE_HARDFP ? coreRegisters[crIndex++] : stack[++stackIndex];
                        value = Primitives.ints2Double(l, h);
                    }
                } else if (paramType == Float.TYPE) {
                    if (floatIndex % 2 == 0) {
                        floatIndex = Math.max(doubleIndex, floatIndex);
                    }
                    if (floatIndex < fpRegisters.length) {
                        value = Float.valueOf(fpRegisters[floatIndex++]);
                    } else {
                        int asInt = crIndex < coreRegisters.length && !USE_HARDFP ? coreRegisters[crIndex++] : stack[stackIndex];
                        value = Float.valueOf(Float.intBitsToFloat(asInt));
                    }
                } else if (paramType == Long.TYPE) {
                    if (crIndex == 0 && hookRecord.isStatic && USE_HARDFP) {
                        int l = coreRegisters[1];
                        int h = coreRegisters[2];
                        args[i] = Primitives.ints2Long(l, h);
                        crIndex = 3;
                        stackIndex += 2;
                        continue;
                    }
                    if (crIndex == 2 && DISALLOW_LONG_CROSS_CR_AND_STACK) {
                        crIndex = 3;
                    }
                    int l = crIndex < coreRegisters.length ? coreRegisters[crIndex++] : stack[stackIndex];
                    int h = crIndex < coreRegisters.length ? coreRegisters[crIndex++] : stack[++stackIndex];
                    value = Primitives.ints2Long(l, h);
                } else {
                    int asInt;
                    int n = asInt = crIndex < coreRegisters.length ? coreRegisters[crIndex++] : stack[stackIndex];
                    if (paramType.isPrimitive()) {
                        if (paramType == Integer.TYPE) {
                            value = asInt;
                        } else if (paramType == Boolean.TYPE) {
                            value = asInt != 0;
                        } else if (paramType == Short.TYPE) {
                            value = (short)asInt;
                        } else if (paramType == Character.TYPE) {
                            value = Character.valueOf((char)asInt);
                        } else {
                            if (paramType != Byte.TYPE) throw new AssertionError((Object)("Unknown primitive type: " + paramType));
                            value = (byte)asInt;
                        }
                    } else {
                        value = Pine.getObject(thread, asInt);
                    }
                }
                args[i] = value;
                ++stackIndex;
            }
            return Pine.handleCall(hookRecord, receiver, args);
        } else {
            args = Pine.EMPTY_OBJECT_ARRAY;
        }
        return Pine.handleCall(hookRecord, receiver, args);
    }

    private static ThreeTuple<int[], int[], float[]> getArgs(Pine.HookRecord hookRecord, int extras, int sp) {
        int fpLength;
        int stackLength;
        int crLength;
        if (hookRecord.paramTypesCache == null) {
            Class<?>[] paramTypes;
            crLength = hookRecord.isStatic ? 0 : 1;
            stackLength = crLength;
            int floatLength = 0;
            int doubleLength = 0;
            for (Class<?> paramType : paramTypes = hookRecord.paramTypes) {
                if (paramType == Double.TYPE) {
                    ++doubleLength;
                    ++stackLength;
                } else if (paramType == Float.TYPE) {
                    ++floatLength;
                } else {
                    if (paramType == Long.TYPE) {
                        if (crLength == 0) {
                            ++crLength;
                        }
                        if (crLength < 3) {
                            ++crLength;
                        }
                        ++stackLength;
                    }
                    if (crLength < 3) {
                        ++crLength;
                    }
                }
                ++stackLength;
            }
            fpLength = doubleLength * 2 + floatLength;
            ParamTypesCache cache = new ParamTypesCache();
            cache.crLength = crLength;
            cache.stackLength = stackLength;
            cache.fpLength = fpLength;
            hookRecord.paramTypesCache = cache;
        } else {
            ParamTypesCache cache = (ParamTypesCache)hookRecord.paramTypesCache;
            crLength = cache.crLength;
            stackLength = cache.stackLength;
            fpLength = cache.fpLength;
        }
        float[] fpRegisters = EMPTY_FLOAT_ARRAY;
        if (USE_HARDFP) {
            if (fpLength != 0) {
                fpRegisters = new float[Math.min(Primitives.evenUp(fpLength), 16)];
            }
        } else {
            crLength = Math.min(crLength + fpLength, 3);
        }
        int[] coreRegisters = crLength != 0 ? new int[crLength] : EMPTY_INT_ARRAY;
        int[] stack = stackLength != 0 ? new int[stackLength] : EMPTY_INT_ARRAY;
        Pine.getArgsArm32(extras, sp, coreRegisters, stack, fpRegisters);
        return new ThreeTuple<int[], int[], float[]>(coreRegisters, stack, fpRegisters);
    }

    private static class ParamTypesCache {
        int crLength;
        int stackLength;
        int fpLength;

        private ParamTypesCache() {
        }
    }
}

