/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.context;

import xyz.erupt.core.context.MetaErupt;
import xyz.erupt.core.context.MetaUser;

public class MetaContext {
    private static final ThreadLocal<MetaContext> threadLocal = ThreadLocal.withInitial(() -> {
        MetaContext metaContext = new MetaContext();
        metaContext.setMetaErupt(new MetaErupt());
        metaContext.setMetaUser(new MetaUser());
        return metaContext;
    });
    private MetaErupt metaErupt;
    private MetaUser metaUser;
    private String token;

    private static MetaContext getContext() {
        return threadLocal.get();
    }

    public static MetaErupt getErupt() {
        return MetaContext.getContext().metaErupt;
    }

    public static MetaUser getUser() {
        return MetaContext.getContext().metaUser;
    }

    public static String getToken() {
        return MetaContext.getContext().token;
    }

    public static void register(MetaErupt metaErupt) {
        MetaContext.getContext().setMetaErupt(metaErupt);
    }

    public static void register(MetaUser metaUser) {
        MetaContext.getContext().setMetaUser(metaUser);
    }

    public static void registerToken(String token) {
        MetaContext.getContext().setToken(token);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public MetaErupt getMetaErupt() {
        return this.metaErupt;
    }

    public MetaUser getMetaUser() {
        return this.metaUser;
    }

    public void setMetaErupt(MetaErupt metaErupt) {
        this.metaErupt = metaErupt;
    }

    public void setMetaUser(MetaUser metaUser) {
        this.metaUser = metaUser;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

