/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import org.fusesource.jansi.Ansi;
import org.slf4j.event.Level;

public class Formatter {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final StringBuilder buf = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Formatter timestamp(Long timestamp) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            this.buf.append(DATE_FORMAT.format(timestamp));
        }
        return this;
    }

    public Formatter space() {
        this.buf.append(" ");
        return this;
    }

    public Formatter level(String level) {
        Ansi ansi = Level.INFO.name().equals(level) ? Ansi.ansi().fg(Ansi.Color.GREEN) : (Level.WARN.name().equals(level) ? Ansi.ansi().fg(Ansi.Color.YELLOW) : (Level.ERROR.name().equals(level) ? Ansi.ansi().fg(Ansi.Color.RED) : Ansi.ansi().fg(Ansi.Color.CYAN)));
        this.buf.append(ansi);
        this.alignment(level, 5);
        this.buf.append(Ansi.ansi().fg(Ansi.Color.DEFAULT));
        return this;
    }

    public Formatter value(String value) {
        this.buf.append(value);
        return this;
    }

    public Formatter thread(String value) {
        this.alignment(value, 15);
        return this;
    }

    public Formatter name(String name) {
        this.buf.append(Ansi.ansi().fg(Ansi.Color.CYAN));
        this.alignment(name, 40);
        this.buf.append(Ansi.ansi().fg(Ansi.Color.DEFAULT));
        return this;
    }

    public Formatter newline() {
        this.buf.append("\n");
        return this;
    }

    public Formatter throwable(Throwable throwable) {
        if (throwable != null) {
            this.newline();
            StringWriter sw = new StringWriter(1024);
            PrintWriter writer = new PrintWriter(sw);
            throwable.printStackTrace(writer);
            writer.close();
            this.buf.append(sw.getBuffer());
            this.newline();
        }
        return this;
    }

    public void alignment(String text, int size) {
        if (text.length() < size) {
            for (int i = size - text.length(); i > 0; --i) {
                this.buf.append(" ");
            }
            this.buf.append(text);
        } else {
            this.buf.append(text.substring(text.length() - size));
        }
    }

    public String toString() {
        return this.buf.toString();
    }
}

