/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.i18n;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedCaseInsensitiveMap;

@Service
public class I18nRunner
extends LinkedCaseInsensitiveMap<Map<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(I18nRunner.class);
    private static final I18nRunner langMappings = new I18nRunner();
    private static final String I18N_EXT = ".csv";

    public static String getI18nValue(String lang, String key) {
        if (null == langMappings.get(lang)) {
            return key;
        }
        return Optional.ofNullable((String)((Map)langMappings.get(lang)).get(key)).orElse(key);
    }

    public void init() {
        Enumeration<URL> urls = I18nRunner.class.getClassLoader().getResources("i18n/");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLDecoder.decode(url.getFile(), Charset.defaultCharset().name())));
                    break;
                }
                case "jar": {
                    JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                    this.scanJar(urlConnection.getJarFile());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File file) {
        block12: {
            BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (fileAttributes.isRegularFile()) {
                String fileName = file.getAbsolutePath();
                if (!fileName.endsWith(I18N_EXT)) break block12;
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                    try {
                        this.writeLang(inputStreamReader);
                        break block12;
                    }
                    finally {
                        if (Collections.singletonList(inputStreamReader).get(0) != null) {
                            inputStreamReader.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(fileInputStream).get(0) != null) {
                        fileInputStream.close();
                    }
                }
            }
            if (fileAttributes.isDirectory()) {
                Optional.ofNullable(file.listFiles()).ifPresent(files -> Arrays.stream(files).forEach(this::scanFile));
            }
        }
    }

    private void scanJar(JarFile jar) {
        Enumeration<JarEntry> jarEntryEnumeration = jar.entries();
        while (jarEntryEnumeration.hasMoreElements()) {
            JarEntry entry = jarEntryEnumeration.nextElement();
            if (!entry.getName().endsWith(I18N_EXT)) continue;
            try (InputStreamReader inputStreamReader = new InputStreamReader(jar.getInputStream(entry), StandardCharsets.UTF_8);){
                this.writeLang(inputStreamReader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLang(InputStreamReader inputStreamReader) {
        BufferedReader reader = new BufferedReader(inputStreamReader);
        try {
            String line;
            ArrayList<String> header = new ArrayList<String>();
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                String[] row = this.parseCsvLine(line);
                for (int i = 0; i < row.length; ++i) {
                    if (first) {
                        header.add(row[i]);
                        if (langMappings.containsKey(row[i])) continue;
                        langMappings.put(row[i], new HashMap());
                        continue;
                    }
                    if (i >= header.size() || null == row[i]) continue;
                    ((Map)langMappings.get(header.get(i))).put(row[0], row[i]);
                }
                first = false;
            }
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    private String[] parseCsvLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        for (char c : line.toCharArray()) {
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ',' && !inQuotes) {
                result.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        result.add(sb.toString());
        return result.toArray(new String[0]);
    }
}

