/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.invoke;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import xyz.erupt.annotation.PreDataProxy;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.invoke.DataProxyContext;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptModel;

public class DataProxyInvoke {
    private static final Set<Class<? extends Annotation>> dataProxyAnnotationContainer = new HashSet<Class<? extends Annotation>>();

    public static void registerAnnotationContainer(Class<? extends Annotation> annotationClass) {
        PreDataProxy preDataProxy = annotationClass.getAnnotation(PreDataProxy.class);
        if (preDataProxy == null) {
            throw new RuntimeException("register error not found @PreDataProxy");
        }
        dataProxyAnnotationContainer.add(annotationClass);
    }

    public static void invoke(EruptModel eruptModel, Consumer<DataProxy<Object>> consumer) {
        dataProxyAnnotationContainer.forEach(pc -> Optional.ofNullable(eruptModel.getClazz().getAnnotation(pc)).ifPresent(it -> {
            PreDataProxy preDataProxy = it.annotationType().getAnnotation(PreDataProxy.class);
            DataProxyContext.set(new DataProxyContext.Data(eruptModel, preDataProxy.params()));
            consumer.accept(DataProxyInvoke.getInstanceBean(preDataProxy.value()));
            DataProxyContext.remove();
        }));
        ReflectUtil.findClassExtendStack(eruptModel.getClazz()).forEach(clazz -> DataProxyInvoke.actionInvokePreDataProxy(eruptModel, clazz, consumer));
        DataProxyInvoke.actionInvokePreDataProxy(eruptModel, eruptModel.getClazz(), consumer);
        Stream.of(eruptModel.getErupt().dataProxy()).forEach(proxy -> {
            DataProxyContext.set(new DataProxyContext.Data(eruptModel, eruptModel.getErupt().dataProxyParams()));
            consumer.accept(DataProxyInvoke.getInstanceBean(proxy));
            DataProxyContext.remove();
        });
    }

    private static void actionInvokePreDataProxy(EruptModel eruptModel, Class<?> clazz, Consumer<DataProxy<Object>> consumer) {
        Stream.of(clazz.getInterfaces()).forEach(it -> Optional.ofNullable(it.getAnnotation(PreDataProxy.class)).ifPresent(dataProxy -> {
            DataProxyContext.set(new DataProxyContext.Data(eruptModel, dataProxy.params()));
            consumer.accept(DataProxyInvoke.getInstanceBean(dataProxy.value()));
            DataProxyContext.remove();
        }));
        Optional.ofNullable(clazz.getAnnotation(PreDataProxy.class)).ifPresent(dataProxy -> {
            DataProxyContext.set(new DataProxyContext.Data(eruptModel, dataProxy.params()));
            consumer.accept(DataProxyInvoke.getInstanceBean(dataProxy.value()));
            DataProxyContext.remove();
        });
    }

    private static DataProxy<Object> getInstanceBean(Class<? extends DataProxy<?>> dataProxy) {
        return EruptSpringUtil.getBean(dataProxy);
    }
}

