/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.util.ArrayList;
import java.util.List;
import xyz.erupt.core.operator.DbOperatorExpr;
import xyz.erupt.core.operator.OperatorStringType;

public enum OperatorReferenceType implements DbOperatorExpr
{
    EQ("\u5305\u542b"){

        @Override
        public String expr(String field, Object value) {
            if (value instanceof List) {
                List s = (List)value;
                return String.format("%s in (%s)", field, 1.geneJoinIn(s));
            }
            if (value instanceof Number) {
                return String.format("%s = %s", field, Integer.parseInt(value.toString()));
            }
            return String.format("%s = '%s'", field, value);
        }
    }
    ,
    NEQ("\u4e0d\u5305\u542b"){

        @Override
        public String expr(String field, Object value) {
            if (value instanceof List) {
                List s = (List)value;
                return String.format("%s not in (%s)", field, 2.geneJoinIn(s));
            }
            if (value instanceof Number) {
                return String.format("%s <> %s", field, Integer.parseInt(value.toString()));
            }
            return String.format("%s <> '%s'", field, value);
        }
    }
    ,
    NULL("\u4e3a\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return OperatorStringType.NULL.expr(field, value);
        }
    }
    ,
    NOT_NULL("\u975e\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return OperatorStringType.NOT_NULL.expr(field, value);
        }
    };

    private final String name;

    public static String geneJoinIn(List<Object> list) {
        ArrayList<String> newList = new ArrayList<String>();
        for (Object o : list) {
            if (o instanceof Number) {
                newList.add(o.toString());
                continue;
            }
            newList.add("'" + o + "'");
        }
        return String.join((CharSequence)",", newList);
    }

    public String getName() {
        return this.name;
    }

    private OperatorReferenceType(String name) {
        this.name = name;
    }
}

