/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.core.operator.DbOperatorExpr;

public enum OperatorStringType implements DbOperatorExpr
{
    EQ("\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s = '%s'", field, value);
        }
    }
    ,
    NEQ("\u4e0d\u7b49\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s != '%s'", field, value);
        }
    }
    ,
    LIKE("\u76f8\u4f3c"){

        @Override
        public String expr(String field, Object value) {
            return field + " like '%" + value + "%'";
        }
    }
    ,
    NOT_LIKE("\u4e0d\u76f8\u4f3c"){

        @Override
        public String expr(String field, Object value) {
            return field + " not like '%" + value + "%'";
        }
    }
    ,
    START_WITH("\u4ee5**\u5f00\u59cb"){

        @Override
        public String expr(String field, Object value) {
            return field + " like '" + value + "%'";
        }
    }
    ,
    END_WITH("\u4ee5**\u7ed3\u5c3e"){

        @Override
        public String expr(String field, Object value) {
            return field + " like '%" + value + "'";
        }
    }
    ,
    IN("\u5305\u542b\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            Collection collection = (Collection)value;
            ArrayList<String> conditions = new ArrayList<String>();
            for (Object object : collection) {
                conditions.add(field + " like'%" + object + "%'");
            }
            return "(" + String.join((CharSequence)" or ", conditions) + ")";
        }
    }
    ,
    NOT_IN("\u4e0d\u5305\u542b\u4e8e"){

        @Override
        public String expr(String field, Object value) {
            Collection collection = (Collection)value;
            ArrayList<String> conditions = new ArrayList<String>();
            for (Object object : collection) {
                conditions.add(field + " not like'%" + object + "%'");
            }
            return "(" + String.join((CharSequence)" or ", conditions) + ")";
        }
    }
    ,
    NULL("\u4e3a\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s is null", field);
        }
    }
    ,
    NOT_NULL("\u975e\u7a7a"){

        @Override
        public String expr(String field, Object value) {
            return String.format("%s is not null", field);
        }
    };

    private final String name;

    public static List<VLModel> fetchList() {
        ArrayList<VLModel> vlModels = new ArrayList<VLModel>();
        for (OperatorStringType value : OperatorStringType.values()) {
            vlModels.add(new VLModel(value.name(), value.getName()));
        }
        return vlModels;
    }

    public String getName() {
        return this.name;
    }

    private OperatorStringType(String name) {
        this.name = name;
    }
}

