/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import xyz.erupt.core.annotation.EruptScan;

public class EruptApplication
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(EruptApplication.class);
    private static Class<?> primarySource;
    private static final Set<String> scanPackage;

    public static String[] getScanPackage() {
        return scanPackage.toArray(new String[0]);
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class clazz = ClassUtils.forName((String)importingClassMetadata.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        Optional.ofNullable(clazz.getAnnotation(SpringBootApplication.class)).ifPresent(it -> {
            primarySource = clazz;
        });
        EruptScan eruptScan = clazz.getAnnotation(EruptScan.class);
        try {
            Class.forName("org.springframework.boot.devtools.RemoteUrlPropertyExtractor");
            log.error("spring-boot-devtools \u4e0e erupt \u540c\u65f6\u5b58\u5728\u4f1a\u51fa\u73b0\u5404\u79cd\u5947\u602a\u7684\u95ee\u9898\uff0c\u5efa\u8bae\u79fb\u9664\u8be5\u4f9d\u8d56\uff01\uff01\uff01");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (eruptScan.value().length == 0) {
            scanPackage.add(clazz.getPackage().getName());
        } else {
            Stream.of(eruptScan.value()).filter(pack -> !pack.equals("xyz.erupt")).forEach(scanPackage::add);
        }
    }

    public static Class<?> getPrimarySource() {
        return primarySource;
    }

    static {
        scanPackage = new HashSet<String>();
    }
}

