/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.service;

import java.io.File;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import xyz.erupt.annotation.fun.AttachmentProxy;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptUtil;

@Service
public class EruptFileService {
    private static final Logger log = LoggerFactory.getLogger(EruptFileService.class);
    @Resource
    private EruptProp eruptProp;

    public String createPath(MultipartFile file) {
        if (file.isEmpty() || StringUtils.isBlank((CharSequence)file.getOriginalFilename())) {
            throw new EruptWebApiRuntimeException("not found file");
        }
        if (this.eruptProp.isKeepUploadFileName()) {
            return File.separator + DateUtil.getFormatDate(new Date(), "yyyy-MM-dd") + File.separator + file.getOriginalFilename().replaceAll("&|#|\\?|\\s", "");
        }
        String[] fileNameSplit = file.getOriginalFilename().split("\\.");
        return File.separator + DateUtil.getFormatDate(new Date(), "yyyy-MM-dd") + File.separator + RandomStringUtils.randomAlphabetic((int)12) + "." + fileNameSplit[fileNameSplit.length - 1];
    }

    public String upload(MultipartFile file, String path) throws Exception {
        try {
            boolean localSave = true;
            AttachmentProxy attachmentProxy = EruptUtil.findAttachmentProxy();
            if (null != attachmentProxy) {
                path = attachmentProxy.upLoad(file.getInputStream(), path.replace("\\", "/"));
                localSave = attachmentProxy.isLocalSave();
            }
            if (localSave) {
                File dest = new File(this.eruptProp.getUploadPath() + path);
                if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                    throw new EruptWebApiRuntimeException(I18nTranslate.$translate("erupt.upload_error.cannot_created") + ": " + dest.getParentFile().getAbsolutePath());
                }
                file.transferTo(dest);
            }
            return path.replace("\\", "/");
        }
        catch (Exception e) {
            log.error("erupt upload error", (Throwable)e);
            throw new EruptWebApiRuntimeException(I18nTranslate.$translate("erupt.upload_error") + " " + e.getMessage());
        }
    }
}

