/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;

public class DateUtil {
    public static final String DATE = "yyyy-MM-dd";
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd' 'HH:mm:ss.SSS", "yyyy-MM-dd' 'HH:mm:ss:SSS", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "dd-MM-yyyy", "yyyy-MM-dd", "dd/MM/yyyy"};

    public static Date parseDate(String dateStr) throws ParseException {
        return DateUtils.parseDateStrictly((String)dateStr, (String[])PATTERNS);
    }

    public static String getSimpleFormatDateTime(Date date) {
        return DateUtil.getFormatDate(date, DATE_TIME);
    }

    public static String getSimpleFormatDate(Date date) {
        return DateUtil.getFormatDate(date, DATE);
    }

    public static String getFormatDate(Date date, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(date);
    }

    public static Object getDate(Class<?> targetDateType, String str) {
        if (targetDateType == Date.class) {
            if (str.length() == 10) {
                return new SimpleDateFormat(DATE).parse(str);
            }
            return new SimpleDateFormat(DATE_TIME).parse(str);
        }
        if (targetDateType == LocalDate.class) {
            return LocalDate.parse(str, DateTimeFormatter.ofPattern(DATE));
        }
        if (targetDateType == LocalDateTime.class) {
            return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(DATE_TIME));
        }
        throw new EruptWebApiRuntimeException("Unsupported date type");
    }
}

