/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.view;

import java.io.Serializable;
import xyz.erupt.core.view.EruptApiModel;

public class R<T>
implements Serializable {
    private T data;
    private String message;
    private boolean success;
    private EruptApiModel.Status status;
    private EruptApiModel.PromptWay promptWay = EruptApiModel.PromptWay.MESSAGE;
    private boolean errorIntercept = true;

    public static <T> R<T> ok(T data) {
        R<T> r = new R<T>();
        r.setSuccess(true);
        r.setData(data);
        r.setPromptWay(EruptApiModel.PromptWay.NONE);
        r.setStatus(EruptApiModel.Status.SUCCESS);
        return r;
    }

    public static <T> R<T> ok() {
        R<T> r = new R<T>();
        r.setSuccess(true);
        r.setStatus(EruptApiModel.Status.SUCCESS);
        return r;
    }

    public static <T> R<T> error(String message) {
        R<T> r = new R<T>();
        r.setSuccess(false);
        r.setMessage(message);
        r.setStatus(EruptApiModel.Status.ERROR);
        return r;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public EruptApiModel.Status getStatus() {
        return this.status;
    }

    public EruptApiModel.PromptWay getPromptWay() {
        return this.promptWay;
    }

    public boolean isErrorIntercept() {
        return this.errorIntercept;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setStatus(EruptApiModel.Status status) {
        this.status = status;
    }

    public void setPromptWay(EruptApiModel.PromptWay promptWay) {
        this.promptWay = promptWay;
    }

    public void setErrorIntercept(boolean errorIntercept) {
        this.errorIntercept = errorIntercept;
    }

    public static enum PromptWay {
        DIALOG,
        MESSAGE,
        NOTIFY,
        NONE;

    }

    public static enum Status {
        SUCCESS,
        ERROR,
        INFO,
        WARNING;

    }
}

