/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.excel.controller;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.config.QueryExpression;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.core.annotation.EruptRecordOperate;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.controller.EruptModifyController;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProxyInvoke;
import xyz.erupt.core.naming.EruptRecordNaming;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptModifyService;
import xyz.erupt.core.service.EruptService;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.SecurityUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.core.view.TableQuery;
import xyz.erupt.excel.service.EruptExcelService;
import xyz.erupt.excel.util.ExcelUtil;

@RestController
@RequestMapping(value={"/erupt-api/excel"})
public class EruptExcelController {
    private static final Logger log = LoggerFactory.getLogger(EruptExcelController.class);
    private final EruptProp eruptProp;
    private final EruptExcelService dataFileService;
    private final EruptModifyService eruptModifyService;
    private final EruptService eruptService;
    private final EruptModifyController eruptModifyController;

    @GetMapping(value={"/template/{erupt}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public void getExcelTemplate(@PathVariable(value="erupt") String eruptName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.eruptProp.isCsrfInspect() && SecurityUtil.csrfInspect((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        Erupts.powerLegal((EruptModel)eruptModel, PowerObject::isImportable);
        try (Workbook wb = this.dataFileService.createExcelTemplate(eruptModel);){
            wb.write(ExcelUtil.downLoadFile(request, response, eruptModel.getErupt().name() + "_template" + ".xls"));
        }
    }

    @PostMapping(value={"/export/{erupt}"})
    @EruptRecordOperate(value="Export Excel", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public void exportData(@PathVariable(value="erupt") String eruptName, @RequestBody(required=false) List<Condition> conditions, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.eruptProp.isCsrfInspect() && SecurityUtil.csrfInspect((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        Erupts.powerLegal((EruptModel)eruptModel, PowerObject::isExport);
        TableQuery tableQuery = new TableQuery();
        tableQuery.setPageIndex(Integer.valueOf(1));
        tableQuery.setPageSize(Integer.valueOf(1000000));
        Optional.ofNullable(conditions).ifPresent(arg_0 -> ((TableQuery)tableQuery).setCondition(arg_0));
        Page page = this.eruptService.getEruptData(eruptModel, tableQuery, null, new String[0]);
        try (Workbook wb = this.dataFileService.exportExcel(eruptModel, page);){
            DataProxyInvoke.invoke((EruptModel)eruptModel, dataProxy -> dataProxy.excelExport((Object)wb));
            this.createConditionSheet(wb, eruptModel, conditions);
            DateUtil.getSimpleFormatDateTime((Date)new Date());
            wb.write(ExcelUtil.downLoadFile(request, response, eruptModel.getErupt().name() + "_" + DateUtil.getFormatDate((Date)new Date(), (String)"yyyy-MM-dd_HH-mm-ss") + ".xlsx"));
        }
    }

    private void createConditionSheet(Workbook wb, EruptModel eruptModel, List<Condition> conditions) {
        Sheet sheet = wb.createSheet("condition");
        sheet.createFreezePane(0, 1, 1, 1);
        sheet.setColumnWidth(0, 4096);
        sheet.setColumnWidth(1, 3072);
        sheet.setColumnWidth(2, 12800);
        Row head = sheet.createRow(sheet.getLastRowNum() + 1);
        head.createCell(0).setCellValue("name");
        head.createCell(1).setCellValue("expr");
        head.createCell(2).setCellValue("value");
        if (null != conditions) {
            conditions.forEach(condition -> {
                EruptField eruptField;
                if (null != condition.getValue() && (eruptField = ((EruptFieldModel)eruptModel.getEruptFieldMap().get(condition.getKey())).getEruptField()).views().length > 0) {
                    Row row = sheet.createRow(sheet.getLastRowNum() + 1);
                    row.createCell(0).setCellValue(eruptField.views()[0].title());
                    row.createCell(1).setCellValue(null == condition.getExpression() ? QueryExpression.EQ.name() : condition.getExpression().name());
                    row.createCell(2).setCellValue(condition.getValue().toString());
                }
            });
        }
    }

    @PostMapping(value={"/import/{erupt}"})
    @EruptRecordOperate(value="Import Excel", dynamicConfig=EruptRecordNaming.class)
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    @Transactional
    public EruptApiModel importExcel(@PathVariable(value="erupt") String eruptName, @RequestParam(value="file") MultipartFile file) {
        List<JsonObject> list;
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        Erupts.powerLegal((EruptModel)eruptModel, PowerObject::isImportable, (String)"Not import permission");
        if (file.isEmpty() || null == file.getOriginalFilename()) {
            return EruptApiModel.errorApi((String)"No file");
        }
        int i = 1;
        try {
            HSSFWorkbook wb;
            ++i;
            if (file.getOriginalFilename().endsWith(".xls")) {
                wb = new HSSFWorkbook(file.getInputStream());
            } else if (file.getOriginalFilename().endsWith(".xlsx")) {
                wb = new XSSFWorkbook(file.getInputStream());
            } else {
                throw new EruptWebApiRuntimeException("The uploaded file format must be Excel");
            }
            DataProxyInvoke.invoke((EruptModel)eruptModel, arg_0 -> EruptExcelController.lambda$importExcel$2((Workbook)wb, arg_0));
            list = this.dataFileService.excelToEruptObject(eruptModel, (Workbook)wb);
            wb.close();
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException("Excel\u89e3\u6790\u5f02\u5e38\uff0c\u51fa\u9519\u884c\u6570\uff1a" + i + "\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
        }
        try {
            ArrayList<Object> eruptDataList = new ArrayList<Object>();
            int j = 1;
            for (JsonObject data : list) {
                ++j;
                EruptApiModel eruptApiModel = EruptUtil.validateEruptValue((EruptModel)eruptModel, (JsonObject)data);
                if (eruptApiModel.getStatus() == EruptApiModel.Status.ERROR) {
                    throw new EruptWebApiRuntimeException("\u7b2c" + j + "\u884c\uff0c" + eruptApiModel.getMessage());
                }
                eruptDataList.add(this.eruptModifyService.eruptInsertDataProcess(eruptModel, data));
            }
            DataProxyInvoke.invoke((EruptModel)eruptModel, dataProxy -> dataProxy.excelImportProcess(eruptDataList));
            this.eruptModifyController.batchAddEruptData(eruptModel, eruptDataList);
        }
        catch (Exception e) {
            log.error("import error {}", (Object)eruptModel.getEruptName(), (Object)e);
            throw new EruptWebApiRuntimeException("\u6570\u636e\u5bfc\u5165\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return EruptApiModel.successApi();
    }

    public EruptExcelController(EruptProp eruptProp, EruptExcelService dataFileService, EruptModifyService eruptModifyService, EruptService eruptService, EruptModifyController eruptModifyController) {
        this.eruptProp = eruptProp;
        this.dataFileService = dataFileService;
        this.eruptModifyService = eruptModifyService;
        this.eruptService = eruptService;
        this.eruptModifyController = eruptModifyController;
    }

    private static /* synthetic */ void lambda$importExcel$2(Workbook wb, DataProxy dataProxy) {
        dataProxy.excelImport((Object)wb);
    }
}

