/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import xyz.erupt.core.annotation.EruptScan;
import xyz.erupt.core.module.EruptModule;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.core.module.ModuleInfo;
import xyz.erupt.job.config.EruptJobProp;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.EruptJobLog;
import xyz.erupt.job.model.EruptMail;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.jpa.dao.EruptDao;

@Configuration
@ComponentScan
@EntityScan
@EruptScan
@Component
@EnableConfigurationProperties
public class EruptJobAutoConfiguration
implements EruptModule {
    private static final Logger log = LoggerFactory.getLogger(EruptJobAutoConfiguration.class);
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptJobService eruptJobService;
    @Resource
    private EruptJobProp eruptJobProp;

    public void run() {
        if (this.eruptJobProp.isEnable()) {
            for (EruptJob job : this.eruptDao.lambdaQuery(EruptJob.class).eq(EruptJob::getStatus, (Object)true).list()) {
                this.eruptJobService.modifyJob(job);
            }
        } else {
            log.info("Erupt job disable");
        }
    }

    public ModuleInfo info() {
        return ModuleInfo.builder().name("erupt-job").build();
    }

    public List<MetaMenu> initMenus() {
        ArrayList<MetaMenu> menus = new ArrayList<MetaMenu>();
        menus.add(MetaMenu.createRootMenu((String)"$job", (String)"\u4efb\u52a1\u7ba1\u7406", (String)"fa fa-cubes", (Integer)30));
        menus.add(MetaMenu.createEruptClassMenu(EruptJob.class, (MetaMenu)((MetaMenu)menus.get(0)), (Integer)0));
        menus.add(MetaMenu.createEruptClassMenu(EruptJobLog.class, (MetaMenu)((MetaMenu)menus.get(0)), (Integer)10));
        menus.add(MetaMenu.createEruptClassMenu(EruptMail.class, (MetaMenu)((MetaMenu)menus.get(0)), (Integer)20));
        return menus;
    }

    static {
        EruptModuleInvoke.addEruptModule(EruptJobAutoConfiguration.class);
    }
}

