/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.ChoiceFetchHandler;
import xyz.erupt.annotation.fun.ChoiceTrigger;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.core.annotation.EruptHandlerNaming;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.job.handler.EruptJobHandler;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.linq.lambda.LambdaSee;

@Component
public class EruptJobFetch
implements ChoiceFetchHandler,
ChoiceTrigger {
    private static final List<VLModel> loadedJobHandler = new ArrayList<VLModel>();

    @PostConstruct
    public void init() {
        EruptSpringUtil.scannerPackage((String[])EruptApplication.getScanPackage(), (TypeFilter[])new TypeFilter[]{new AssignableTypeFilter(EruptJobHandler.class)}, clazz -> {
            EruptHandlerNaming eruptHandlerNaming = clazz.getAnnotation(EruptHandlerNaming.class);
            if (null == eruptHandlerNaming) {
                loadedJobHandler.add(new VLModel(clazz.getName(), ((EruptJobHandler)EruptSpringUtil.getBean((Class)clazz)).name(), clazz.getName()));
            } else {
                loadedJobHandler.add(new VLModel(clazz.getName(), eruptHandlerNaming.value(), clazz.getName()));
            }
        });
    }

    public synchronized List<VLModel> fetch(String[] params) {
        return loadedJobHandler;
    }

    public Map<String, Object> trigger(Object value, String[] params) {
        for (VLModel vl : loadedJobHandler) {
            if (!vl.getValue().equals(value)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            EruptJobHandler jobHandler = (EruptJobHandler)EruptSpringUtil.getBeanByPath((String)vl.getDesc(), EruptJobHandler.class);
            map.put(LambdaSee.field(EruptJob::getName), vl.getLabel());
            if (null != jobHandler.param()) {
                map.put(LambdaSee.field(EruptJob::getHandlerParam), jobHandler.param());
            }
            if (null != jobHandler.cron()) {
                map.put(LambdaSee.field(EruptJob::getCron), jobHandler.cron());
            }
            return map;
        }
        return Collections.emptyMap();
    }
}

