/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.toolkit.notify;

import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProxyContext;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.toolkit.notify.DataAction;
import xyz.erupt.toolkit.notify.NotifyData;

@Component
public class RedisNotifyDataProxy
implements DataProxy<Object> {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private EruptProp eruptProp;

    public void afterAdd(Object o) {
        this.publish(DataAction.ADD, o);
    }

    public void afterUpdate(Object o) {
        this.publish(DataAction.UPDATE, o);
    }

    public void afterDelete(Object o) {
        this.publish(DataAction.DELETE, o);
    }

    private void publish(DataAction action, Object data) {
        if (this.eruptProp.isRedisSession()) {
            if (null == DataProxyContext.params()[0]) {
                throw new EruptWebApiRuntimeException("DataProxy params[0] not found \u2192 redis channel");
            }
            this.stringRedisTemplate.convertAndSend(DataProxyContext.params()[0], (Object)GsonFactory.getGson().toJson(new NotifyData<Object>(action, data)));
        }
    }
}

