/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.handler;

import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.PowerHandler;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.upms.enums.EruptFunPermissions;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.UPMSUtil;

@Service
public class UpmsPowerHandler
implements PowerHandler {
    @Resource
    private EruptUserService eruptUserService;

    public void handler(PowerObject power) {
        Map<String, Boolean> permissionMap = this.eruptUserService.getEruptMenuValuesMap();
        if (power.isAdd()) {
            power.setAdd(this.powerOff(EruptFunPermissions.ADD, permissionMap));
        }
        if (power.isDelete()) {
            power.setDelete(this.powerOff(EruptFunPermissions.DELETE, permissionMap));
        }
        if (power.isEdit()) {
            power.setEdit(this.powerOff(EruptFunPermissions.EDIT, permissionMap));
        }
        if (power.isViewDetails()) {
            power.setViewDetails(this.powerOff(EruptFunPermissions.VIEW_DETAIL, permissionMap));
        }
        if (power.isExport()) {
            power.setExport(this.powerOff(EruptFunPermissions.EXPORT, permissionMap));
        }
        if (power.isImportable()) {
            power.setImportable(this.powerOff(EruptFunPermissions.IMPORTABLE, permissionMap));
        }
    }

    private boolean powerOff(EruptFunPermissions eruptFunPermissions, Map<String, Boolean> permissionMap) {
        return permissionMap.containsKey(UPMSUtil.getEruptFunPermissionsCode(MetaContext.getErupt().getName(), eruptFunPermissions).toLowerCase());
    }

    static {
        PowerInvoke.registerPowerHandler(UpmsPowerHandler.class);
    }
}

