/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import com.airbnb.lottie.AnimatableValue;
import org.json.JSONArray;

class ColorFactory
implements AnimatableValue.Factory<Integer> {
    static final ColorFactory INSTANCE = new ColorFactory();

    ColorFactory() {
    }

    @Override
    public Integer valueFromObject(Object object, float scale) {
        JSONArray colorArray = (JSONArray)object;
        if (colorArray.length() == 4) {
            boolean shouldUse255 = true;
            for (int i = 0; i < colorArray.length(); ++i) {
                double colorChannel = colorArray.optDouble(i);
                if (!(colorChannel > 1.0)) continue;
                shouldUse255 = false;
            }
            float multiplier = shouldUse255 ? 255.0f : 1.0f;
            return Color.argb((int)((int)(colorArray.optDouble(3) * (double)multiplier)), (int)((int)(colorArray.optDouble(0) * (double)multiplier)), (int)((int)(colorArray.optDouble(1) * (double)multiplier)), (int)((int)(colorArray.optDouble(2) * (double)multiplier)));
        }
        return -16777216;
    }
}

