/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.support.annotation.FloatRange;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ShapeLayer;
import java.util.ArrayList;
import java.util.List;

class CompositionLayer
extends BaseLayer {
    private final List<BaseLayer> layers = new ArrayList<BaseLayer>();

    CompositionLayer(LottieDrawable lottieDrawable, Layer layerModel, List<Layer> layerModels, LottieComposition composition) {
        super(lottieDrawable, layerModel);
        int i;
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        BaseLayer mattedLayer = null;
        for (i = layerModels.size() - 1; i >= 0; --i) {
            Layer lm = layerModels.get(i);
            BaseLayer layer = BaseLayer.forModel(lm, lottieDrawable, composition);
            layerMap.put(layer.getLayerModel().getId(), (Object)layer);
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layer);
                mattedLayer = null;
                continue;
            }
            this.layers.add(0, layer);
            switch (lm.getMatteType()) {
                case Add: 
                case Invert: {
                    mattedLayer = layer;
                }
            }
        }
        for (i = 0; i < layerMap.size(); ++i) {
            long key = layerMap.keyAt(i);
            BaseLayer layerView = (BaseLayer)layerMap.get(key);
            BaseLayer parentLayer = (BaseLayer)layerMap.get(layerView.getLayerModel().getParentId());
            if (parentLayer == null) continue;
            layerView.setParentLayer(parentLayer);
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).draw(canvas, parentMatrix, parentAlpha);
        }
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        super.setProgress(progress);
        progress -= this.layerModel.getStartProgress();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).setProgress(progress);
        }
    }

    boolean hasMasks() {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            BaseLayer layer = this.layers.get(i);
            if (!(layer instanceof ShapeLayer) || !layer.hasMasksOnThisLayer()) continue;
            return true;
        }
        return false;
    }

    boolean hasMatte() {
        if (this.hasMatteOnThisLayer()) {
            return true;
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (!this.layers.get(i).hasMatteOnThisLayer()) continue;
            return true;
        }
        return false;
    }
}

