/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableShapeValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONObject;

class Mask {
    private final MaskMode maskMode;
    private final AnimatableShapeValue maskPath;

    private Mask(MaskMode maskMode, AnimatableShapeValue maskPath) {
        this.maskMode = maskMode;
        this.maskPath = maskPath;
    }

    MaskMode getMaskMode() {
        return this.maskMode;
    }

    AnimatableShapeValue getMaskPath() {
        return this.maskPath;
    }

    static class Factory {
        private Factory() {
        }

        static Mask newMask(JSONObject json, LottieComposition composition) {
            MaskMode maskMode;
            switch (json.optString("mode")) {
                case "a": {
                    maskMode = MaskMode.MaskModeAdd;
                    break;
                }
                case "s": {
                    maskMode = MaskMode.MaskModeSubtract;
                    break;
                }
                case "i": {
                    maskMode = MaskMode.MaskModeIntersect;
                    break;
                }
                default: {
                    maskMode = MaskMode.MaskModeUnknown;
                }
            }
            AnimatableShapeValue maskPath = AnimatableShapeValue.Factory.newInstance(json.optJSONObject("pt"), composition);
            return new Mask(maskMode, maskPath);
        }
    }

    static enum MaskMode {
        MaskModeAdd,
        MaskModeSubtract,
        MaskModeIntersect,
        MaskModeUnknown;

    }
}

