/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.DrawingContent;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.Utils;
import java.util.ArrayList;
import java.util.List;

class StrokeContent
implements DrawingContent,
BaseKeyframeAnimation.AnimationListener {
    private final Path path = new Path();
    private final Paint paint = new Paint(1);
    private final LottieDrawable lottieDrawable;
    private final List<PathContent> paths = new ArrayList<PathContent>();
    private final float[] dashPatternValues;
    private final BaseKeyframeAnimation<?, Integer> colorAnimation;
    private final BaseKeyframeAnimation<?, Float> widthAnimation;
    private final BaseKeyframeAnimation<?, Integer> opacityAnimation;
    private final List<BaseKeyframeAnimation<?, Float>> dashPatternAnimations;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> dashPatternOffsetAnimation;

    StrokeContent(LottieDrawable lottieDrawable, BaseLayer layer, ShapeStroke stroke) {
        int i;
        this.lottieDrawable = lottieDrawable;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(stroke.getCapType().toPaintCap());
        this.paint.setStrokeJoin(stroke.getJoinType().toPaintJoin());
        this.colorAnimation = stroke.getColor().createAnimation();
        this.opacityAnimation = stroke.getOpacity().createAnimation();
        this.widthAnimation = stroke.getWidth().createAnimation();
        this.dashPatternOffsetAnimation = stroke.getDashOffset() == null ? null : stroke.getDashOffset().createAnimation();
        List<AnimatableFloatValue> dashPattern = stroke.getLineDashPattern();
        this.dashPatternAnimations = new ArrayList(dashPattern.size());
        this.dashPatternValues = new float[dashPattern.size()];
        for (i = 0; i < dashPattern.size(); ++i) {
            this.dashPatternAnimations.add(dashPattern.get(i).createAnimation());
        }
        layer.addAnimation(this.colorAnimation);
        layer.addAnimation(this.opacityAnimation);
        layer.addAnimation(this.widthAnimation);
        for (i = 0; i < this.dashPatternAnimations.size(); ++i) {
            layer.addAnimation(this.dashPatternAnimations.get(i));
        }
        if (this.dashPatternOffsetAnimation != null) {
            layer.addAnimation(this.dashPatternOffsetAnimation);
        }
        this.colorAnimation.addUpdateListener(this);
        this.opacityAnimation.addUpdateListener(this);
        this.widthAnimation.addUpdateListener(this);
        for (i = 0; i < dashPattern.size(); ++i) {
            this.dashPatternAnimations.get(i).addUpdateListener(this);
        }
        if (this.dashPatternOffsetAnimation != null) {
            this.dashPatternOffsetAnimation.addUpdateListener(this);
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsAfter.size(); ++i) {
            Content content = contentsAfter.get(i);
            if (!(content instanceof PathContent)) continue;
            this.paths.add((PathContent)content);
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        this.paint.setColor(this.colorAnimation.getValue().intValue());
        int alpha = (int)((float)parentAlpha / 255.0f * (float)this.opacityAnimation.getValue().intValue() / 100.0f * 255.0f);
        this.paint.setAlpha(alpha);
        this.paint.setStrokeWidth(this.widthAnimation.getValue().floatValue() * Utils.getScale(parentMatrix));
        if (this.paint.getStrokeWidth() < 1.0f) {
            return;
        }
        this.applyDashPatternIfNeeded();
        this.path.reset();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.path.addPath(this.paths.get(i).getPath(), parentMatrix);
        }
        canvas.drawPath(this.path, this.paint);
    }

    private void applyDashPatternIfNeeded() {
        if (this.dashPatternAnimations.isEmpty()) {
            return;
        }
        float scale = this.lottieDrawable.getScale();
        int i = 0;
        while (i < this.dashPatternAnimations.size()) {
            this.dashPatternValues[i] = this.dashPatternAnimations.get(i).getValue().floatValue();
            if (i % 2 == 0) {
                if (this.dashPatternValues[i] < 1.0f) {
                    this.dashPatternValues[i] = 1.0f;
                }
            } else if (this.dashPatternValues[i] < 0.1f) {
                this.dashPatternValues[i] = 0.1f;
            }
            int n = i++;
            this.dashPatternValues[n] = this.dashPatternValues[n] * scale;
        }
        float offset = this.dashPatternOffsetAnimation == null ? 0.0f : this.dashPatternOffsetAnimation.getValue().floatValue();
        this.paint.setPathEffect((PathEffect)new DashPathEffect(this.dashPatternValues, offset));
    }
}

